import type { BBox } from './bbox';
import { type CanvasOptions, HdpiCanvas } from './canvas/hdpiCanvas';
import { LayersManager } from './layersManager';
import { Node } from './node';
export declare class Scene {
    static readonly className = "Scene";
    private readonly debug;
    readonly id: string;
    readonly canvas: HdpiCanvas;
    readonly layersManager: LayersManager;
    private root;
    private pendingSize;
    private isDirty;
    constructor(canvasOptions: CanvasOptions);
    get width(): number;
    get height(): number;
    get pixelRatio(): number;
    /** @deprecated v10.2.0 Only used by AG Grid Sparklines */
    setContainer(value: HTMLElement): this;
    setRoot(node: Node | null): this;
    clear(): void;
    attachNode<T extends Node>(node: T): () => this;
    appendChild<T extends Node>(node: T): this;
    removeChild<T extends Node>(node: T): this;
    download(fileName?: string, fileFormat?: string): void;
    /** NOTE: Integrated Charts undocumented image download method. */
    getDataURL(fileFormat?: string): string;
    resize(width: number, height: number, pixelRatio: number | undefined): boolean;
    render(opts?: {
        debugSplitTimes: Record<string, number>;
        extraDebugStats: Record<string, number>;
        seriesRect?: BBox;
    }): void;
    toSVG(): string | undefined;
    /** Alternative to destroy() that preserves re-usable resources. */
    strip(): void;
    destroy(): void;
}
