import type { NormalizedDomain, Scale, ScaleFormatParams, ScaleTickParams, ScaleType } from './scale';
export declare abstract class AbstractScale<D, R, I = number> implements Scale<D, R, I> {
    abstract type: ScaleType;
    abstract domain: D[];
    abstract range: R[];
    abstract normalizeDomains(...domains: D[][]): NormalizedDomain<D>;
    abstract toDomain(value: number): D | undefined;
    abstract convert(value: D, clamp?: boolean): R;
    abstract invert(value: R, nearest?: boolean): D | undefined;
    ticks(_ticks: ScaleTickParams<I>, _domain?: D[], _visibleRange?: [number, number]): D[] | undefined;
    niceDomain(_ticks: ScaleTickParams<I>, domain?: D[]): D[];
    tickFormatter(_params: ScaleFormatParams<D>): ((x: any) => string) | undefined;
    datumFormatter(_params: ScaleFormatParams<D>): ((x: any) => string) | undefined;
    get bandwidth(): number | undefined;
    get step(): number | undefined;
    get inset(): number | undefined;
}
