import type { InteractionRange, TextWrap } from 'ag-charts-types';
import type { DOMManager } from '../../dom/domManager';
import { BaseProperties } from '../../util/properties';
import { type LegendSymbolOptions } from '../legend/legendSymbol';
export declare const DEFAULT_TOOLTIP_CLASS = "ag-charts-tooltip";
export declare const DEFAULT_TOOLTIP_DARK_CLASS = "ag-charts-tooltip--dark";
type TooltipPositionType = 'pointer' | 'node' | 'top' | 'right' | 'bottom' | 'left' | 'top-left' | 'top-right' | 'bottom-right' | 'bottom-left' | 'sparkline' | 'sparkline-constrained';
type TooltipOffsets = {
    canvasX: number;
    canvasY: number;
};
export type TooltipEventType = 'pointermove' | 'click' | 'dblclick' | 'keyboard';
export type TooltipPointerEvent<T extends TooltipEventType = TooltipEventType> = Readonly<TooltipOffsets> & {
    readonly type: T;
};
export interface TooltipMetaPosition {
    type?: TooltipPositionType;
    xOffset?: number;
    yOffset?: number;
}
export interface TooltipMeta extends TooltipOffsets {
    showArrow?: boolean;
    lastPointerEvent?: TooltipPointerEvent;
    position?: TooltipMetaPosition;
    enableInteraction?: boolean;
}
export type TooltipContentDataRow = {
    label: string;
    fallbackLabel?: string;
    value: string;
} | {
    label: undefined;
    fallbackLabel: string;
    value: string;
};
export type TooltipStructuredContent = {
    heading?: string;
    title?: string;
    symbol?: LegendSymbolOptions;
    data?: TooltipContentDataRow[];
};
export type TooltipContent = ({
    type: 'structured';
} & TooltipStructuredContent) | {
    type: 'raw';
    rawHtmlString: string;
};
export declare function tooltipContentAriaLabel(content: TooltipContent): string;
export declare class TooltipPosition extends BaseProperties {
    /** The type of positioning for the tooltip. By default, the tooltip follows the pointer. */
    type: TooltipPositionType;
    /** The horizontal offset in pixels for the position of the tooltip. */
    xOffset: number;
    /** The vertical offset in pixels for the position of the tooltip. */
    yOffset: number;
}
export declare class Tooltip extends BaseProperties {
    enabled: boolean;
    showArrow?: boolean;
    delay: number;
    range?: InteractionRange;
    wrapping: TextWrap;
    readonly position: TooltipPosition;
    darkTheme: boolean;
    /** Escape-hatch for changes in AG-11645. */
    bounds: 'extended' | 'canvas';
    private readonly destroyFns;
    private readonly springAnimation;
    private enableInteraction;
    private readonly wrapTypes;
    private element?;
    private showTimeout;
    private _showArrow;
    private _compact;
    private _visible;
    private positionParams;
    get interactive(): boolean;
    constructor();
    setup(domManager: DOMManager): void;
    destroy(domManager: DOMManager): void;
    isVisible(): boolean;
    contains(node: Node | null): boolean;
    private updateTooltipPosition;
    /**
     * Shows tooltip at the given event's coordinates.
     * If the `html` parameter is missing, moves the existing tooltip to the new position.
     */
    show(boundingRect: DOMRect, canvasRect: DOMRect, meta: TooltipMeta, content?: TooltipContent | null, instantly?: boolean): void;
    hide(): void;
    private toggle;
    private updateShowArrow;
    private updateCompact;
    private getTooltipBounds;
}
export {};
