import type { DOMManager } from '../../dom/domManager';
import type { MouseWidgetEvent } from '../../widget/widgetEvents';
import type { ErrorBoundSeriesNodeDatum, ISeries, SeriesNodeDatum } from '../series/seriesTypes';
import type { Tooltip, TooltipContent, TooltipMeta, TooltipPointerEvent } from '../tooltip/tooltip';
/**
 * Manages the tooltip HTML an element. Tracks the requested HTML from distinct dependents and
 * handles conflicting tooltip requests.
 */
export declare class TooltipManager {
    private readonly domManager;
    private readonly tooltip;
    private readonly stateTracker;
    private readonly suppressState;
    private appliedState;
    constructor(domManager: DOMManager, tooltip: Tooltip);
    updateTooltip(callerId: string, meta?: TooltipMeta, content?: TooltipContent): void;
    removeTooltip(callerId: string): void;
    suppressTooltip(callerId: string): void;
    unsuppressTooltip(callerId: string): void;
    destroy(): void;
    private applyStates;
    static makeTooltipMeta(event: TooltipPointerEvent, series: ISeries<any, any>, datum: SeriesNodeDatum<unknown> & Pick<ErrorBoundSeriesNodeDatum, 'yBar'>): TooltipMeta;
    isEnteringInteractiveTooltip(event: MouseWidgetEvent<'mouseleave'>): boolean;
}
