import type { AgContextMenuOptions } from 'ag-charts-types';
import type { CategoryLegendDatum } from '../legend/legendDatum';
import type { ISeries, SeriesNodeDatum } from '../series/seriesTypes';
type ContextTypeMap = {
    all: object;
    legend: {
        legendItem: CategoryLegendDatum | undefined;
    };
    'series-area': {
        pickedSeries: ISeries<any, any> | undefined;
        pickedNode: SeriesNodeDatum<unknown> | undefined;
    };
    node: {
        pickedSeries: ISeries<any, any> | undefined;
        pickedNode: SeriesNodeDatum<unknown> | undefined;
    };
};
export type MouseEventWithPointerType = MouseEvent & Partial<Pick<PointerEvent, 'pointerType'>>;
export type ContextType = keyof ContextTypeMap;
export type ContextMenuEvent<K extends ContextType = ContextType> = {
    readonly type: K;
    readonly x: number;
    readonly y: number;
    readonly context: Readonly<ContextTypeMap[K]>;
    readonly sourceEvent: MouseEventWithPointerType;
};
type ContextMenuActionEventMap = {
    all: Parameters<NonNullable<AgContextMenuOptions['extraActions']>[number]['action']>[0];
    legend: Parameters<NonNullable<AgContextMenuOptions['extraLegendItemActions']>[number]['action']>[0];
    'series-area': Parameters<NonNullable<AgContextMenuOptions['extraSeriesAreaActions']>[number]['action']>[0];
    node: Parameters<NonNullable<AgContextMenuOptions['extraNodeActions']>[number]['action']>[0];
};
export type ContextMenuCallback<K extends ContextType> = {
    all: (params: ContextMenuActionEventMap['all']) => void;
    legend: (params: ContextMenuActionEventMap['legend']) => void;
    'series-area': (params: ContextMenuActionEventMap['series-area']) => void;
    node: (params: ContextMenuActionEventMap['node']) => void;
}[K];
export type ContextMenuAction<K extends ContextType> = {
    id?: string;
    label: string;
    type: K;
    action: ContextMenuCallback<K>;
    toggleEnabledOnShow?: (event: ContextMenuEvent) => boolean;
};
export declare class ContextMenuRegistry {
    private readonly defaultActions;
    private readonly disabledActions;
    private readonly hiddenActions;
    private readonly listeners;
    static check<T extends ContextType>(type: T, event: ContextMenuEvent): event is ContextMenuEvent<T>;
    static checkCallback<T extends ContextType>(desiredType: T, type: ContextType, _callback: ContextMenuCallback<ContextType>): _callback is ContextMenuCallback<T>;
    dispatchContext<T extends ContextType>(type: T, pointerEvent: {
        sourceEvent: MouseEvent;
        canvasX: number;
        canvasY: number;
    }, context: ContextTypeMap[T], position?: {
        x: number;
        y: number;
    }): void;
    addListener(handler: (event: ContextMenuEvent) => void): () => void;
    filterActions(type: ContextType): ContextMenuAction<ContextType>[];
    registerDefaultAction<T extends ContextType>(action: ContextMenuAction<T>): () => void;
    enableAction(actionId: string): void;
    disableAction(actionId: string): void;
    showAction(actionId: string): void;
    hideAction(actionId: string): void;
    isDisabled(actionId: string): boolean;
}
export {};
