import type { AgCartesianCrossLineLabelOptions, AgCrossLineLabelPosition, FontStyle, FontWeight } from 'ag-charts-types';
import type { Scale } from '../../scale/scale';
import { Group } from '../../scene/group';
import { BaseProperties } from '../../util/properties';
import { ChartAxisDirection } from '../chartAxisDirection';
import { type CrossLine, type CrossLineType } from './crossLine';
import type { CrossLineLabelPosition } from './crossLineLabelPosition';
declare class CartesianCrossLineLabel extends BaseProperties implements AgCartesianCrossLineLabelOptions {
    enabled?: boolean;
    text?: string;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    fontSize: number;
    fontFamily: string;
    /**
     * The padding between the label and the line.
     */
    padding: number;
    /**
     * The color of the labels.
     */
    color?: string;
    position?: CrossLineLabelPosition;
    rotation?: number;
    parallel?: boolean;
}
export declare class CartesianCrossLine extends BaseProperties implements CrossLine<CartesianCrossLineLabel> {
    static readonly className = "CrossLine";
    readonly id: string;
    enabled?: boolean;
    type?: CrossLineType;
    range?: [any, any];
    value?: any;
    fill?: string;
    fillOpacity?: number;
    stroke?: string;
    strokeWidth?: number;
    strokeOpacity?: number;
    lineDash?: [];
    label: CartesianCrossLineLabel;
    scale?: Scale<any, number>;
    clippedRange: [number, number];
    gridLength: number;
    sideFlag: 1 | -1;
    parallelFlipRotation: number;
    regularFlipRotation: number;
    direction: ChartAxisDirection;
    readonly rangeGroup: Group<any>;
    readonly lineGroup: Group<any>;
    readonly labelGroup: Group<any>;
    private readonly crossLineRange;
    private readonly crossLineLabel;
    private labelPoint?;
    private data;
    private startLine;
    private endLine;
    private isRange;
    constructor();
    private _isRange;
    update(visible: boolean): void;
    calculateLayout(visible: boolean, reversedAxis?: boolean): void;
    private updateNodes;
    private updateRangeNode;
    private updateLabel;
    private positionLabel;
    private getRange;
    private computeLabelBBox;
    calculatePadding(padding: Partial<Record<AgCrossLineLabelPosition, number>>): void;
}
export {};
