import type { Scale } from '../../scale/scale';
import type { BBox } from '../../scene/bbox';
import { Axis } from './axis';
import type { TickInterval } from './axisTick';
export interface PolarAxisPathPoint {
    x: number;
    y: number;
    moveTo: boolean;
    radius?: number;
    startAngle?: number;
    endAngle?: number;
    arc?: boolean;
}
export declare abstract class PolarAxis<S extends Scale<D, number, TickInterval<S>> = Scale<any, number, any>, D = any, TickDatum = any, TickLabelDatum = TickDatum> extends Axis<S, D, TickDatum, TickLabelDatum> {
    gridAngles: number[] | undefined;
    gridRange: number[] | undefined;
    shape: 'polygon' | 'circle';
    innerRadiusRatio: number;
    defaultTickMinSpacing: number;
    updatePosition(): void;
    computeLabelsBBox(_options: {
        hideWhenNecessary: boolean;
    }, _seriesRect: BBox): BBox | null;
    computeRange(): void;
    getAxisLinePoints(): {
        points: PolarAxisPathPoint[];
        closePath: boolean;
    } | undefined;
}
