import type { FontStyle, FontWeight } from 'ag-charts-types';
import type { ModuleContext } from '../../module/moduleContext';
import { GroupedCategoryScale } from '../../scale/groupedCategoryScale';
import { BBox } from '../../scene/bbox';
import { BaseProperties, PropertiesArray } from '../../util/properties';
import { CategoryAxis } from './categoryAxis';
declare class DepthLabelProperties extends BaseProperties {
    enabled: boolean;
    avoidCollisions?: boolean;
    color?: string;
    spacing?: number;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    fontSize?: number;
    fontFamily?: string;
}
declare class DepthTickProperties extends BaseProperties {
    enabled: boolean;
    width?: number;
    stroke?: string;
}
declare class DepthProperties extends BaseProperties {
    label: DepthLabelProperties;
    tick: DepthTickProperties;
}
export declare class GroupedCategoryAxis extends CategoryAxis {
    static readonly className = "GroupedCategoryAxis";
    static readonly type: "grouped-category";
    readonly tickScale: GroupedCategoryScale<string[], number>;
    private computedLayout?;
    private tickTreeLayout?;
    depthOptions: PropertiesArray<DepthProperties>;
    constructor(moduleCtx: ModuleContext);
    private resizeTickTree;
    private getDepthOptionsMap;
    private updateCategoryLabels;
    private updateAxisLine;
    private computeLayout;
    /**
     * Creates/removes/updates the scene graph nodes that constitute the axis.
     * Supposed to be called _manually_ after changing _any_ of the axis properties.
     * This allows to bulk set axis properties before updating the nodes.
     * The node changes made by this method are rendered on the next animation frame.
     * We could schedule this method call automatically on the next animation frame
     * when any of the axis properties change (the way we do when properties of scene graph's
     * nodes change), but this will mean that we first wait for the next animation
     * frame to make changes to the nodes of the axis, then wait for another animation
     * frame to render those changes. It's nice to have everything update automatically,
     * but this extra level of async indirection will not just introduce an unwanted delay,
     * it will also make it harder to reason about the program.
     */
    update(): void;
    calculateLayout(): {
        bbox: BBox;
        primaryTickCount: undefined;
        niceDomain: (string | object)[];
    };
    /**
     * The length of the grid. The grid is only visible in case of a non-zero value.
     */
    onGridVisibilityChange(): void;
    protected updateScale(): void;
    processData(): {
        animatable: boolean;
    };
    protected updateGridLines(): void;
    filterDuplicateArrays(array: string[][]): string[][];
}
export {};
