import type { AgCartesianAxisPosition } from 'ag-charts-types';
import type { AxisContext } from '../../module/axisContext';
import type { ModuleContext } from '../../module/moduleContext';
import { type FromToDiff } from '../../motion/fromToMotion';
import type { Scale } from '../../scale/scale';
import { BBox } from '../../scene/bbox';
import { StateMachine } from '../../util/stateMachine';
import type { ChartAnimationPhase } from '../chartAnimationPhase';
import { ChartAxisDirection } from '../chartAxisDirection';
import type { AnimationManager } from '../interaction/animationManager';
import { Axis, type LabelNodeDatum, TranslatableLine } from './axis';
import type { NiceMode, TickDatum } from './axisUtil';
import { CartesianAxisLabel } from './cartesianAxisLabel';
type AxisAnimationState = 'empty' | 'ready';
type AxisAnimationEvent = {
    reset: undefined;
    resize: undefined;
    update: FromToDiff;
};
export declare abstract class CartesianAxis<S extends Scale<D, number, any> = Scale<any, number, any>, D = any> extends Axis<S, D, TickDatum, LabelNodeDatum> {
    static is(value: unknown): value is CartesianAxis<any>;
    thickness?: number;
    position: AgCartesianAxisPosition;
    protected animationManager: AnimationManager;
    protected readonly lineNode: TranslatableLine;
    private readonly tempText;
    private readonly tempCaption;
    private readonly tickGenerator;
    private generatedTicks;
    protected readonly animationState: StateMachine<AxisAnimationState, AxisAnimationEvent>;
    constructor(moduleCtx: ModuleContext, scale: S);
    resetAnimation(phase: ChartAnimationPhase): void;
    get direction(): ChartAxisDirection;
    createAxisContext(): AxisContext;
    protected createLabel(): CartesianAxisLabel;
    protected updateDirection(): void;
    calculateLayout(primaryTickCount?: number): {
        primaryTickCount: number | undefined;
        bbox: BBox | undefined;
    };
    calculateTickLayout(domain: D[], niceMode: NiceMode, visibleRange: [number, number], initialPrimaryTickCount?: number): {
        niceDomain: D[];
        primaryTickCount: number | undefined;
        tickDomain: D[];
        ticks: D[];
        fractionDigits: number;
        bbox: BBox;
    };
    update(): void;
    protected updatePosition(): void;
    private tickBBox;
    private getTickLabelProps;
    private getTickLineCoordinates;
    protected updateSelections(): void;
    protected updateTitle(noVisibleTicks?: boolean, spacing?: number): void;
    protected updateLabels(): void;
    private animateReadyUpdate;
    protected resetSelectionNodes(): void;
}
export {};
