import type { AppConfig } from '@nuxt/schema';
import type { ButtonProps, ComponentConfig } from '@nuxt/ui';
import theme from '#build/ui-pro/dashboard-navbar';
import type { DashboardContext } from '../utils/dashboard';
type DashboardNavbar = ComponentConfig<typeof theme, AppConfig, 'dashboardNavbar', 'uiPro'>;
export interface DashboardNavbarProps {
    /**
     * The element or component this component should render as.
     * @defaultValue 'div'
     */
    as?: any;
    /**
     * The icon displayed next to the title.
     * @IconifyIcon
     */
    icon?: string;
    title?: string;
    /**
     * Customize the toggle button to open the sidebar.
     * `{ color: 'neutral', variant: 'ghost' }`{lang="ts-type"}
     * @defaultValue true
     */
    toggle?: boolean | Partial<ButtonProps>;
    /**
     * The side to render the toggle button on.
     * @defaultValue 'left'
     */
    toggleSide?: 'left' | 'right';
    class?: any;
    ui?: DashboardNavbar['slots'];
}
type DashboardNavbarSlotsProps = Omit<DashboardContext, 'storage' | 'storageKey' | 'persistent' | 'unit'>;
export interface DashboardNavbarSlots {
    title(props?: {}): any;
    leading(props: DashboardNavbarSlotsProps): any;
    trailing(props: DashboardNavbarSlotsProps): any;
    left(props: DashboardNavbarSlotsProps): any;
    default(props: DashboardNavbarSlotsProps): any;
    right(props: DashboardNavbarSlotsProps): any;
    toggle(props: DashboardNavbarSlotsProps): any;
}
declare const _default: __VLS_WithSlots<import("vue").DefineComponent<DashboardNavbarProps, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<DashboardNavbarProps> & Readonly<{}>, {
    toggle: boolean | Partial<ButtonProps>;
    toggleSide: "left" | "right";
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, DashboardNavbarSlots>;
export default _default;
type __VLS_WithSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
