import { defu } from 'defu';
import { defineNuxtModule, createResolver, addVitePlugin, addPlugin, addComponentsDir, addImportsDir, hasNuxtModule, installModule } from '@nuxt/kit';
import { d as defaultOptions, r as resolveColors, a as getDefaultUiConfig, b as addTemplates } from './shared/ui.Bix4DSU4.mjs';
import '../dist/runtime/utils/index.js';
import 'node:url';
import 'scule';
import 'tailwindcss/colors';
import 'knitwork';

const name = "@nuxt/ui";
const version = "3.1.3";

const module = defineNuxtModule({
  meta: {
    name,
    version,
    docs: "https://ui.nuxt.com/getting-started/installation/nuxt",
    configKey: "ui",
    compatibility: {
      nuxt: ">=3.16.0"
    }
  },
  defaults: defaultOptions,
  async setup(options, nuxt) {
    const { resolve } = createResolver(import.meta.url);
    options.theme = options.theme || {};
    options.theme.colors = resolveColors(options.theme.colors);
    nuxt.options.ui = options;
    nuxt.options.alias["#ui"] = resolve("./runtime");
    nuxt.options.appConfig.ui = defu(nuxt.options.appConfig.ui || {}, getDefaultUiConfig(options.theme.colors));
    nuxt.options.app.rootAttrs = nuxt.options.app.rootAttrs || {};
    nuxt.options.app.rootAttrs.class = [nuxt.options.app.rootAttrs.class, "isolate"].filter(Boolean).join(" ");
    if (nuxt.options.builder === "@nuxt/vite-builder") {
      const plugin = await import('@tailwindcss/vite').then((r) => r.default);
      addVitePlugin(plugin());
    } else {
      nuxt.options.postcss.plugins["@tailwindcss/postcss"] = {};
    }
    async function registerModule(name2, key, options2) {
      if (!hasNuxtModule(name2)) {
        await installModule(name2, options2);
      } else {
        nuxt.options[key] = defu(nuxt.options[key], options2);
      }
    }
    await registerModule("@nuxt/icon", "icon", {
      cssLayer: "components"
    });
    if (options.fonts) {
      await registerModule("@nuxt/fonts", "fonts", {
        defaults: {
          weights: [400, 500, 600, 700]
        }
      });
    }
    if (options.colorMode) {
      await registerModule("@nuxtjs/color-mode", "colorMode", {
        classSuffix: "",
        disableTransition: true
      });
    }
    addPlugin({ src: resolve("./runtime/plugins/colors") });
    addComponentsDir({
      path: resolve("./runtime/components"),
      prefix: options.prefix,
      pathPrefix: false
    });
    addImportsDir(resolve("./runtime/composables"));
    addTemplates(options, nuxt, resolve);
  }
});

export { module as default };
