import { Font as Font$1 } from 'fontkit';

declare const _default: {
    latin: {
        "0": number;
        "1": number;
        "2": number;
        "3": number;
        "4": number;
        "5": number;
        "6": number;
        "7": number;
        "8": number;
        "9": number;
        ",": number;
        " ": number;
        t: number;
        h: number;
        e: number;
        o: number;
        f: number;
        P: number;
        p: number;
        l: number;
        "'": number;
        s: number;
        R: number;
        u: number;
        b: number;
        i: number;
        c: number;
        C: number;
        n: number;
        a: number;
        d: number;
        y: number;
        w: number;
        B: number;
        r: number;
        z: number;
        G: number;
        j: number;
        T: number;
        ".": number;
        L: number;
        k: number;
        m: number;
        "]": number;
        J: number;
        F: number;
        v: number;
        g: number;
        A: number;
        N: number;
        "-": number;
        H: number;
        D: number;
        M: number;
        I: number;
        E: number;
        "\"": number;
        S: number;
        "(": number;
        ")": number;
        x: number;
        W: number;
        Q: number;
        Y: number;
        q: number;
        V: number;
        á: number;
        K: number;
        U: number;
        "=": number;
        "[": number;
        O: number;
        é: number;
        $: number;
        ":": number;
        "|": number;
        "/": number;
        "%": number;
        Z: number;
        ";": number;
        X: number;
    };
    thai: {
        ส: number;
        ว: number;
        น: number;
        บ: number;
        จ: number;
        า: number;
        ก: number;
        เ: number;
        ร: number;
        ม: number;
        ค: number;
        ำ: number;
        ข: number;
        อ: number;
        ป: number;
        ด: number;
        ใ: number;
        ภ: number;
        ท: number;
        พ: number;
        ฤ: number;
        ษ: number;
        ศ: number;
        ะ: number;
        ช: number;
        แ: number;
        ล: number;
        ง: number;
        ย: number;
        ห: number;
        ฝ: number;
        ต: number;
        โ: number;
        ญ: number;
        ณ: number;
        ผ: number;
        ไ: number;
        ฯ: number;
        ฟ: number;
        ธ: number;
        ถ: number;
        ฐ: number;
        ซ: number;
        ฉ: number;
        ฑ: number;
        ฆ: number;
        ฬ: number;
        ฏ: number;
        ฎ: number;
        ฒ: number;
        ๆ: number;
        ฮ: number;
        "\u0E52": number;
        "\u0E55": number;
    };
};

type SupportedSubsets = keyof typeof _default;
declare const supportedSubsets: ("latin" | "thai")[];
declare const unpackMetricsFromFont: (font: Font$1) => {
    familyName: string;
    fullName: string;
    postscriptName: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<"latin" | "thai", {
        xWidthAvg: number;
    }>;
};
type Font = ReturnType<typeof unpackMetricsFromFont>;
interface Options {
    postscriptName?: string;
}
declare const fromFile: (path: string, options?: Options) => Promise<Font>;
declare const fromBuffer: (buffer: Buffer, options?: Options) => Promise<Font>;
declare const fromBlob: (blob: Blob, options?: Options) => Promise<Font>;
declare const fromUrl: (url: string, options?: Options) => Promise<Font>;

export { type Font, type SupportedSubsets, fromBlob, fromBuffer, fromFile, fromUrl, supportedSubsets };
