/**
 * Converts the font family name to the correct casing for the relevant metrics import.
 *
 * ---
 * Example usage:
 *
 * ```ts
 * import { fontFamilyToCamelCase } from '@capsizecss/metrics';
 *
 * const familyName = fontFamilyToCamelCase('--apple-system'); // => `appleSystem`
 * const metrics = await import(`@capsizecss/metrics/${familyName}`);
 * ```
 * ---
 */
declare function fontFamilyToCamelCase(str: string): string;

interface AppleSystemMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArialMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BlinkMacSystemFontMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BrushScriptMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CourierNewMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface GeorgiaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface HelveticaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface HelveticaNeueMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface LucidaGrandeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface SegoeUIMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '350': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '350italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface TahomaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface TimesNewRomanMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface TrebuchetMSMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface VerdanaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface _42dotSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ABeeZeeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AbelMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AbhayaLibreMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AboretoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AbrilFatfaceMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AbyssinicaSILMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AclonicaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AcmeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ActorMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AdaminaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ADLaMDisplayMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AdventProMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AfacadMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AfacadFluxMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AgbalumoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AgdasimaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AguDisplayMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AguafinaScriptMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AkatabMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AkayaKanadakaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AkayaTelivigalaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AkronimMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AksharMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AladinMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlataMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlatsiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlbertSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AldrichMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlefMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlegreyaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlegreyaSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlegreyaSansSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlegreyaSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AleoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlexBrushMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlexandriaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlfaSlabOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AliceMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlikeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlikeAngularMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlkalamiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlkatraMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AllanMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AllertaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AllertaStencilMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AllisonMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlluraMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlmaraiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlmendraMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlmendraDisplayMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlmendraSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlumniSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlumniSansCollegiateOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlumniSansInlineOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AlumniSansPinstripeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AmaranteMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AmaranthMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AmaticSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AmethystaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AmikoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AmiriMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AmiriQuranMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AmitaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnaheimMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AndadaProMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AndikaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekBanglaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekDevanagariMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekGujaratiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekGurmukhiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekKannadaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekLatinMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekMalayalamMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekOdiaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekTamilMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnekTeluguMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AngkorMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnnapurnaSILMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnnieUseYourTelescopeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnonymousProMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AntaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnticMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnticDidoneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnticSlabMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AntonMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AntonSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AntonioMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnuphanMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AnybodyMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AoboshiOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AROneSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArapeyMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArbutusMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArbutusSlabMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArchitectsDaughterMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArchivoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArchivoBlackMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArchivoNarrowMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AreYouSeriousMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArefRuqaaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArefRuqaaInkMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArimaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArimoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArizoniaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArmataMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArsenalMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArsenalSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArtifikaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ArvoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AryaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AsapMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AsapCondensedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AsarMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AssetMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AssistantMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AstlochMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AsulMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AthitiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AtkinsonHyperlegibleMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AtkinsonHyperlegibleMonoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AtkinsonHyperlegibleNextMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AtmaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AtomicAgeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AubreyMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AudiowideMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AutourOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AverageMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AverageSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AveriaGruesaLibreMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AveriaLibreMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AveriaSansLibreMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AveriaSerifLibreMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface AzeretMonoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface B612Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface B612MonoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BabylonicaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BacasimeAntiqueMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BadScriptMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BadeenDisplayMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BagelFatOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BahianaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BahianitaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BaiJamjureeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BakbakOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalletMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface Baloo2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalooBhai2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalooBhaijaan2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalooBhaina2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalooChettan2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalooDa2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalooPaaji2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalooTamma2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalooTammudu2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalooThambi2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalsamiqSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BalthazarMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BangersMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BarlowMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BarlowCondensedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BarlowSemiCondensedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BarriecitoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BarrioMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BasicMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BaskervvilleMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BaskervvilleSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BattambangMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BaumansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BayonMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BeVietnamProMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BeauRivageMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BebasNeueMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BeirutiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BelanosimaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BelgranoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BellefairMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BellezaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BellotaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BellotaTextMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BenchNineMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BenneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BenthamMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BerkshireSwashMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BesleyMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BethEllenMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BevanMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BhuTukaExpandedOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BigShouldersMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BigShouldersInlineMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BigShouldersStencilMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BigelowRulesMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BigshotOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BilboMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BilboSwashCapsMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BioRhymeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BioRhymeExpandedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BirthstoneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BirthstoneBounceMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BiryaniMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BitterMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BIZUDGothicMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BIZUDMinchoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BIZUDPGothicMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BIZUDPMinchoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BlackAndWhitePictureMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BlackHanSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BlackOpsOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BlakaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BlakaHollowMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BlakaInkMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BlinkerMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BodoniModaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BodoniModaSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BokorMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BoldonseMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BonaNovaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BonaNovaSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BonbonMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BonheurRoyaleMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BoogalooMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BorelMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BowlbyOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BowlbyOneSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BraahOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BrawlerMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BreeSerifMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BricolageGrotesqueMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BrunoAceMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BrunoAceSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface Brygada1918Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BubblegumSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BubblerOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BudaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BuenardMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BungeeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BungeeHairlineMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BungeeInlineMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BungeeOutlineMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BungeeShadeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BungeeSpiceMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BungeeTintMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ButchermanMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ButterflyKidsMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface BytesizedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CabinMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CabinCondensedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CabinSketchMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CactusClassicalSerifMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CaesarDressingMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CagliostroMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CairoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CairoPlayMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CaladeaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CalistogaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CalligraffittiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CambayMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CamboMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CandalMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CantarellMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CantataOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CantoraOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CaprasimoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CapriolaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CaramelMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CarattereMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CardoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CarlitoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CarmeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CarroisGothicMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CarroisGothicSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CarterOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CastoroMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CastoroTitlingMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CatamaranMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CaudexMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CaveatMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CaveatBrushMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CedarvilleCursiveMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CevicheOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChakraPetchMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChangaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChangaOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChangoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CharisSILMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CharmMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CharmonmanMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChathuraMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChauPhilomeneOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChelaOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChelseaMarketMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChenlaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CherishMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CherryBombOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CherryCreamSodaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CherrySwashMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChewyMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChicleMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChilankaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChivoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChivoMonoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChocolateClassicalSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChokokutaiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ChonburiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CinzelMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CinzelDecorativeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ClickerScriptMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ClimateCrisisMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CodaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CodystarMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CoinyMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ComboMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ComfortaaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ComforterMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ComforterBrushMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ComicNeueMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ComingSoonMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CommeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CommissionerMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ConcertOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CondimentMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ContentMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ContrailOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ConvergenceMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CookieMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CopseMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CorbenMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CorinthiaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CormorantMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CormorantGaramondMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CormorantInfantMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CormorantSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CormorantUnicaseMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CormorantUprightMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CourgetteMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CourierPrimeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CousineMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CoustardMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CoveredByYourGraceMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CraftyGirlsMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CreepsterMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CreteRoundMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CrimsonProMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CrimsonTextMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CroissantOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CrushedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CuprumMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CuteFontMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CutiveMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface CutiveMonoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DaiBannaSILMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DamionMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DancingScriptMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DanfoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DangrekMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DarkerGrotesqueMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DarumadropOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DavidLibreMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DawningOfANewDayMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DaysOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DekkoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DelaGothicOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DeliciousHandrawnMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DeliusMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DeliusSwashCapsMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DeliusUnicaseMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DellaRespiraMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DenkOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DevonshireMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DhurjatiMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DidactGothicMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DiphylleiaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DiplomataMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DiplomataSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DMMonoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DMSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DMSerifDisplayMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DMSerifTextMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DoHyeonMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DokdoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DomineMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DonegalOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DongleMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DoppioOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DorsaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DosisMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DotGothic16Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DotoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DrSugiyamaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DuruSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DynalightMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface DynaPuffMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EagleLakeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EastSeaDokdoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EaterMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EBGaramondMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EconomicaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EczarMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduAUVICWANTArrowsMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduAUVICWANTDotsMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduAUVICWANTGuidesMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduAUVICWANTHandMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduAUVICWANTPreMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduNSWACTFoundationMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduQLDBeginnerMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduSABeginnerMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduTASBeginnerMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EduVICWANTBeginnerMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ElMessiriMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ElectrolizeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ElsieMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ElsieSwashCapsMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EmblemaOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EmilysCandyMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EncodeSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EncodeSansCondensedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EncodeSansExpandedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EncodeSansSCMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EncodeSansSemiCondensedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EncodeSansSemiExpandedMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EngagementMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EnglebertMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EnriquetaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EphesisMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EpilogueMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EricaOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EstebanMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EstoniaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EuphoriaScriptMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface EwertMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ExoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface Exo2Metrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '100': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '100italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ExpletusSansMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface ExploraMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FacultyGlyphicMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FahkwangMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '200': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '200italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FamiljenGroteskMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FanwoodTextMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FarroMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FarsanMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FascinateMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FascinateInlineMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FasterOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FasthandMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FaunaOneMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FaustinaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FederantMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FederoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FelipaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FenixMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FestiveMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FigtreeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '300italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '800italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '900italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FingerPaintMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FinlandicaMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'italic': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FiraCodeMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>;
    variants: {
        '300': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '500': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '600': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        '700': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
        'regular': {
            familyName: string;
            fullName: string;
            postscriptName: string;
            category: string;
            capHeight: number;
            ascent: number;
            descent: number;
            lineGap: number;
            unitsPerEm: number;
            xHeight: number;
            xWidthAvg: number;
            subsets: Record<'latin' | 'thai', {
                xWidthAvg: number;
            }>;
        };
    };
}
interface FiraMonoMetrics {
    familyName: string;
    fullName: string;
    postscriptName: string;
    category: string;
    capHeight: number;
    ascent: number;
    descent: number;
    lineGap: number;
    unitsPerEm: number;
    xHeight: number;
    xWidthAvg: number;
    subsets: Record<'latin' | 'thai', {
        xWidthAvg: number;
    }>