import { Dropdown, IDropdownSettings, IDropdownPrivate, IDropdownEvents } from "./Dropdown";
export interface IDropdownListItem {
    id: string;
    label: string;
    subLabel?: string;
    className?: string;
    icon?: SVGElement;
    form?: "radio" | "checkbox";
    value?: string;
    checked?: boolean;
    options?: IDropdownListItem[];
    disabled?: boolean;
}
export interface IDropdownListSettings extends IDropdownSettings {
    /**
     * A list of items in the dropdown.
     */
    items?: IDropdownListItem[];
    /**
     * Maximum search items to show.
     */
    maxSearchItems?: number;
    /**
     * Is the list searchable? If `true` shows search field and
     * calls `searchCallback` function for a list of items.
     */
    searchable?: boolean;
    /**
     * A callback function which returns a list of items based on a search query.
     */
    searchCallback?: (query: string) => Promise<IDropdownListItem[]>;
    /**
     * An array of item IDs to now show in the list.
     *
     * @since 5.7.0
     */
    exclude?: string[];
}
export interface IDropdownListPrivate extends IDropdownPrivate {
    list?: HTMLUListElement;
    search?: HTMLDivElement;
    currentId?: string;
}
export interface IDropdownListEvents extends IDropdownEvents {
    invoked: {
        item: IDropdownListItem;
    };
    changed: {
        item: IDropdownListItem;
        value: string | boolean;
    };
}
/**
 * A dropdown control for [[StockToolbar]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/stock/toolbar/dropdown-list-control/} for more info
 */
export declare class DropdownList extends Dropdown {
    static className: string;
    static classNames: Array<string>;
    _settings: IDropdownListSettings;
    _privateSettings: IDropdownListPrivate;
    _events: IDropdownListEvents;
    private _currentSelectedIndex?;
    protected _afterNew(): void;
    protected _initElements(): void;
    protected _sizeItems(): void;
    /**
     * Rebuilds the list.
     *
     * Useful when changing item data within item list.
     *
     * @since 5.7.0
     */
    rebuildList(): void;
    protected _initItems(items?: IDropdownListItem[]): void;
    protected _initSearch(): void;
    _beforeChanged(): void;
    protected _dispose(): void;
    protected _filterItems(search?: string): Promise<void>;
    addItem(info: IDropdownListItem): void;
    hide(): void;
    protected _setupKeyboardNav(): void;
    protected _maybeMakeAccessible(): void;
    protected _getActiveItems(): NodeList;
}
//# sourceMappingURL=DropdownList.d.ts.map