import { DropTarget, DragSourceType, DragItem } from "../dragAndDrop/dragAndDropService";
import { Component } from "./component";
export declare abstract class PillDragComp<TItem> extends Component {
    private dragSourceDropTarget;
    private ghost;
    private horizontal;
    private template?;
    static EVENT_COLUMN_REMOVE: string;
    private static TEMPLATE;
    private readonly dragAndDropService;
    private eText;
    private eDragHandle;
    private eButton;
    abstract getItem(): TItem;
    protected abstract getDisplayName(): string;
    protected abstract getAriaDisplayName(): string;
    protected abstract getTooltip(): string | null | undefined;
    protected abstract createGetDragItem(): () => DragItem<TItem>;
    protected abstract getDragSourceType(): DragSourceType;
    constructor(dragSourceDropTarget: DropTarget, ghost: boolean, horizontal: boolean, template?: string | undefined);
    init(): void;
    protected isDraggable(): boolean;
    protected refreshDraggable(): void;
    protected setupAria(): void;
    protected addAdditionalAriaInstructions(ariaInstructions: string[], translate: (key: string, defaultValue: string) => string): void;
    private setupTooltip;
    protected getDragSourceId(): string | undefined;
    protected getDefaultIconName(): string;
    private addDragSource;
    protected setupComponents(): void;
    protected isRemovable(): boolean;
    protected refreshRemove(): void;
    private setupRemove;
    protected onKeyDown(e: KeyboardEvent): void;
    protected getDisplayValue(): string;
    private setTextValue;
    private addElementClasses;
    protected destroy(): void;
}
