import { Context } from "../context/context";
import { ColumnModel } from "../columns/columnModel";
import { HeaderNavigationService } from "../headerRendering/common/headerNavigationService";
import { RowRenderer } from "./rowRenderer";
import { ValueService } from "../valueService/valueService";
import { EventService } from "../eventService";
import { ColumnAnimationService } from "./columnAnimationService";
import { IRangeService, ISelectionHandleFactory } from "../interfaces/IRangeService";
import { FocusService } from "../focusService";
import { PopupService } from "../widgets/popupService";
import { StylingService } from "../styling/stylingService";
import { ColumnHoverService } from "./columnHoverService";
import { PaginationProxy } from "../pagination/paginationProxy";
import { AnimationFrameService } from "../misc/animationFrameService";
import { UserComponentFactory } from "../components/framework/userComponentFactory";
import { DragService } from "../dragAndDrop/dragService";
import { DragAndDropService } from "../dragAndDrop/dragAndDropService";
import { SortController } from "../sortController";
import { FilterManager } from "../filter/filterManager";
import { RowContainerHeightService } from "./rowContainerHeightService";
import { IFrameworkOverrides } from "../interfaces/iFrameworkOverrides";
import { CellPositionUtils } from "../entities/cellPositionUtils";
import { RowPositionUtils } from "../entities/rowPositionUtils";
import { ISelectionService } from "../interfaces/iSelectionService";
import { RowCssClassCalculator } from "./row/rowCssClassCalculator";
import { IRowModel } from "../interfaces/iRowModel";
import { IClientSideRowModel } from "../interfaces/iClientSideRowModel";
import { IServerSideRowModel } from "../interfaces/iServerSideRowModel";
import { ResizeObserverService } from "../misc/resizeObserverService";
import { CtrlsService } from "../ctrlsService";
import { NavigationService } from "../gridBodyComp/navigationService";
import { AgStackComponentsRegistry } from "../components/agStackComponentsRegistry";
import { CtrlsFactory } from "../ctrlsFactory";
import { UserComponentRegistry } from "../components/framework/userComponentRegistry";
import { ValueCache } from "../valueService/valueCache";
import { RowNodeEventThrottle } from "../entities/rowNodeEventThrottle";
import { GridOptionsService } from "../gridOptionsService";
import { LocaleService } from "../localeService";
import { Environment } from "../environment";
import { SyncService } from "../syncService";
import { AriaAnnouncementService } from "./ariaAnnouncementService";
/** Using the IoC has a slight performance consideration, which is no problem most of the
 * time, unless we are trashing objects - which is the case when scrolling and rowComp
 * and cellComp. So for performance reasons, RowComp and CellComp do not get autowired
 * with the IoC. Instead they get passed this object which is all the beans the RowComp
 * and CellComp need. Not autowiring all the cells gives performance improvement. */
export declare class Beans {
    readonly resizeObserverService: ResizeObserverService;
    readonly paginationProxy: PaginationProxy;
    readonly context: Context;
    readonly gos: GridOptionsService;
    readonly environment: Environment;
    readonly rowRenderer: RowRenderer;
    readonly valueService: ValueService;
    readonly eventService: EventService;
    readonly columnModel: ColumnModel;
    readonly headerNavigationService: HeaderNavigationService;
    readonly navigationService: NavigationService;
    readonly columnAnimationService: ColumnAnimationService;
    readonly focusService: FocusService;
    readonly popupService: PopupService;
    readonly stylingService: StylingService;
    readonly columnHoverService: ColumnHoverService;
    readonly userComponentFactory: UserComponentFactory;
    readonly userComponentRegistry: UserComponentRegistry;
    readonly animationFrameService: AnimationFrameService;
    readonly dragService: DragService;
    readonly dragAndDropService: DragAndDropService;
    readonly sortController: SortController;
    readonly filterManager: FilterManager;
    readonly rowContainerHeightService: RowContainerHeightService;
    readonly frameworkOverrides: IFrameworkOverrides;
    readonly cellPositionUtils: CellPositionUtils;
    readonly rowPositionUtils: RowPositionUtils;
    readonly selectionService: ISelectionService;
    readonly rowCssClassCalculator: RowCssClassCalculator;
    readonly rowModel: IRowModel;
    readonly ctrlsService: CtrlsService;
    readonly ctrlsFactory: CtrlsFactory;
    readonly agStackComponentsRegistry: AgStackComponentsRegistry;
    readonly valueCache: ValueCache;
    readonly rowNodeEventThrottle: RowNodeEventThrottle;
    readonly localeService: LocaleService;
    readonly syncService: SyncService;
    readonly ariaAnnouncementService: AriaAnnouncementService;
    readonly rangeService?: IRangeService;
    readonly selectionHandleFactory?: ISelectionHandleFactory;
    clientSideRowModel: IClientSideRowModel;
    serverSideRowModel: IServerSideRowModel;
    private postConstruct;
}
