import { Component } from './component';
type GroupItem = Component | HTMLElement;
type Align = 'start' | 'end' | 'center' | 'stretch';
type Direction = 'horizontal' | 'vertical';
export interface AgGroupComponentParams {
    title?: string;
    enabled?: boolean;
    suppressEnabledCheckbox?: boolean;
    suppressOpenCloseIcons?: boolean;
    suppressToggleExpandOnEnableChange?: boolean;
    cssIdentifier?: string;
    items?: GroupItem[];
    alignItems?: Align;
    direction?: Direction;
    onEnableChange?: (enabled: boolean) => void;
    expanded?: boolean;
    useToggle?: boolean;
}
export declare class AgGroupComponent extends Component {
    private readonly params;
    static EVENT_EXPANDED: string;
    static EVENT_COLLAPSED: string;
    static EVENT_ENABLE_CHANGE: string;
    private items;
    private cssIdentifier;
    private enabled;
    private expanded;
    private suppressEnabledCheckbox;
    private suppressToggleExpandOnEnableChange;
    private alignItems;
    private useToggle;
    private eToggle?;
    private eTitleBar?;
    private eToolbar;
    private cbGroupEnabled;
    private eContainer;
    constructor(params?: AgGroupComponentParams);
    private static getTemplate;
    private postConstruct;
    private refreshChildDisplay;
    isExpanded(): boolean;
    setAlignItems(alignment: AgGroupComponentParams['alignItems']): this;
    toggleGroupExpand(expanded?: boolean): this;
    addItems(items: GroupItem[]): void;
    prependItem(item: GroupItem): void;
    addItem(item: GroupItem): void;
    private insertItem;
    hideItem(hide: boolean, index: number): void;
    getItemIndex(item: GroupItem): number | -1;
    setTitle(title: string): this;
    addTitleBarWidget(el: Element): this;
    addCssClassToTitleBar(cssClass: string): void;
    private dispatchEnableChangeEvent;
    setEnabled(enabled: boolean, skipToggle?: boolean, skipExpand?: boolean): this;
    isEnabled(): boolean;
    onEnableChange(callbackFn: (enabled: boolean) => void): this;
    hideEnabledCheckbox(hide: boolean): this;
    hideOpenCloseIcons(hide: boolean): this;
    private refreshDisabledStyles;
    private setupTitleBar;
    private createDefaultTitleBar;
    private createToggleTitleBar;
}
export {};
