# parse-gitignore [![NPM version](https://img.shields.io/npm/v/parse-gitignore.svg?style=flat)](https://www.npmjs.com/package/parse-gitignore) [![NPM monthly downloads](https://img.shields.io/npm/dm/parse-gitignore.svg?style=flat)](https://npmjs.org/package/parse-gitignore) [![NPM total downloads](https://img.shields.io/npm/dt/parse-gitignore.svg?style=flat)](https://npmjs.org/package/parse-gitignore) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/parse-gitignore.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/parse-gitignore)

> Parse a .gitignore or .npmignore file into an array of patterns.

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save parse-gitignore
```

## Heads up!

### Breaking changes in v1.0!

Prior to v1.0, this library also attempted to convert the returned patterns into valid globs.

As of v1.0, parse-gitignore was refactored and simplified down to less than ~50 sloc and no dependencies to provide a quick and easy way of getting the array of ignore patterns from a [.gitignore](#.gitignore) file. This allows you to do whatever you need to do with the patterns.

## Usage

```js
const fs = require('fs');
const parse = require('parse-gitignore');

// pass the contents of a .gitignore file as a string or buffer
console.log(parse(fs.readFileSync('foo/bar/.gitignore')));
//=> ['*.DS_Store', 'node_modules', ...];
```

## Example

Parses the contents of a `.gitignore` file, like the folowing:

```sh
# Logs
logs
*.log
npm-debug.log*
yarn-debug.log*
yarn-error.log*

# Runtime data
pids
*.pid
*.seed
*.pid.lock
```

Into an array, like the following:

```js
[ 'logs',
  '*.log',
  'npm-debug.log*',
  'yarn-debug.log*',
  'yarn-error.log*',
  'pids',
  '*.pid',
  '*.seed',
  '*.pid.lock' ]
```

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Related projects

You might also be interested in these projects:

* [parse-author](https://www.npmjs.com/package/parse-author): Parse an author, contributor, maintainer or other 'person' string into an object with name, email… [more](https://github.com/jonschlinkert/parse-author) | [homepage](https://github.com/jonschlinkert/parse-author "Parse an author, contributor, maintainer or other 'person' string into an object with name, email and url properties following npm conventions.")
* [parse-git-config](https://www.npmjs.com/package/parse-git-config): Parse `.git/config` into a JavaScript object. sync or async. | [homepage](https://github.com/jonschlinkert/parse-git-config "Parse `.git/config` into a JavaScript object. sync or async.")
* [parse-github-url](https://www.npmjs.com/package/parse-github-url): Parse a github URL into an object. | [homepage](https://github.com/jonschlinkert/parse-github-url "Parse a github URL into an object.")

### Contributors

| **Commits** | **Contributor** |
| --- | --- |
| 33 | [jonschlinkert](https://github.com/jonschlinkert) |
| 1 | [schnittstabil](https://github.com/schnittstabil) |
| 1 | [RMacfarlane](https://github.com/RMacfarlane) |

### Author

**Jon Schlinkert**

* [LinkedIn Profile](https://linkedin.com/in/jonschlinkert)
* [GitHub Profile](https://github.com/jonschlinkert)
* [Twitter Profile](https://twitter.com/jonschlinkert)

### License

Copyright © 2018, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on July 26, 2018._
