import type { AbstractColDef, BeanCollection, ColumnEventType, ComponentSelector } from 'ag-grid-community';
import { Component } from 'ag-grid-community';
import { ColumnModelItem } from './columnModelItem';
import type { ToolPanelColumnCompParams } from './columnToolPanel';
export type AgPrimaryColsListEvent = 'groupExpanded' | 'selectionChanged';
export declare class AgPrimaryColsList extends Component<AgPrimaryColsListEvent> {
    private colModel;
    wireBeans(beans: BeanCollection): void;
    private allowDragging;
    private filterText;
    private expandGroupsByDefault;
    private params;
    private eventType;
    private groupsExist;
    private virtualList;
    private allColsTree;
    private displayedColsList;
    private destroyColumnItemFuncs;
    private hasLoadedInitialState;
    private isInitialState;
    constructor();
    destroy(): void;
    private destroyColumnTree;
    init(params: ToolPanelColumnCompParams, allowDragging: boolean, eventType: ColumnEventType): void;
    private createComponentFromItem;
    onColumnsChanged(): void;
    getDisplayedColsList(): ColumnModelItem[];
    private getExpandedStates;
    private setExpandedStates;
    private buildTreeFromWhatGridIsDisplaying;
    setColumnLayout(colDefs: AbstractColDef[]): void;
    private buildTreeFromProvidedColumnDefs;
    private buildListModel;
    private onColumnExpanded;
    private flattenAndFilterModel;
    private refreshAriaLabel;
    private focusRowIfAlive;
    private forEachItem;
    doSetExpandedAll(value: boolean): void;
    setGroupsExpanded(expand: boolean, groupIds?: string[]): void;
    private getExpandState;
    doSetSelectedAll(selectAllChecked: boolean): void;
    private getSelectionState;
    setFilterText(filterText: string): void;
    private markFilteredColumns;
    private notifyListeners;
    private fireGroupExpandedEvent;
    private fireSelectionChangedEvent;
    getExpandedGroups(): string[];
}
export declare const AgPrimaryColsListSelector: ComponentSelector;
