import { type AgPyramidSeriesStyle, _ModuleSupport } from 'ag-charts-community';
import { FunnelConnector } from '../funnel/funnelConnector';
import { PyramidProperties } from './pyramidProperties';
type PyramidNodeLabelDatum = Readonly<_ModuleSupport.Point> & {
    readonly text: string;
    readonly textAlign: CanvasTextAlign;
    readonly textBaseline: CanvasTextBaseline;
    readonly visible: boolean;
};
interface PyramidNodeDatum extends _ModuleSupport.DataModelSeriesNodeDatum, Readonly<_ModuleSupport.Point> {
    readonly index: number;
    readonly xValue: string;
    readonly yValue: number;
    readonly top: number;
    readonly right: number;
    readonly bottom: number;
    readonly left: number;
    readonly label: PyramidNodeLabelDatum | undefined;
}
interface PyramidNodeDataContext extends _ModuleSupport.DataModelSeriesNodeDataContext<PyramidNodeDatum, PyramidNodeLabelDatum> {
    stageLabelData: PyramidNodeLabelDatum[] | undefined;
}
type ItemStyle = Pick<AgPyramidSeriesStyle, 'fill' | 'stroke'> & Required<Omit<AgPyramidSeriesStyle, 'fill' | 'stroke'>>;
export declare class PyramidSeries extends _ModuleSupport.DataModelSeries<PyramidNodeDatum, PyramidProperties, PyramidNodeLabelDatum, PyramidNodeDataContext> {
    static readonly className = "PyramidSeries";
    static readonly type: "pyramid";
    properties: PyramidProperties;
    private readonly itemGroup;
    private readonly itemLabelGroup;
    private readonly stageLabelGroup;
    datumSelection: _ModuleSupport.Selection<FunnelConnector, PyramidNodeDatum>;
    private labelSelection;
    private stageLabelSelection;
    private highlightDatumSelection;
    contextNodeData?: PyramidNodeDataContext;
    constructor(moduleCtx: _ModuleSupport.ModuleContext);
    addChartEventListeners(): void;
    private nodeFactory;
    getNodeData(): PyramidNodeDatum[] | undefined;
    processData(dataController: _ModuleSupport.DataController): Promise<void>;
    createNodeData(): {
        itemId: string;
        nodeData: PyramidNodeDatum[];
        labelData: PyramidNodeLabelDatum[];
        stageLabelData: PyramidNodeLabelDatum[] | undefined;
    } | undefined;
    updateSelections(): void;
    update({ seriesRect }: {
        seriesRect?: _ModuleSupport.BBox;
    }): void;
    private updateDatumSelection;
    private getItemBaseStyle;
    protected getItemStyleOverrides(datumId: string, datum: any, datumIndex: number, format: ItemStyle, highlighted: boolean): Partial<ItemStyle>;
    private updateDatumNodes;
    private updateLabelSelection;
    private updateStageLabelSelection;
    private updateLabelNodes;
    resetAnimation(_chartAnimationPhase: _ModuleSupport.ChartAnimationPhase): void;
    protected computeFocusBounds(opts: _ModuleSupport.PickFocusInputs): _ModuleSupport.BBox | _ModuleSupport.Path | undefined;
    getTooltipContent(nodeDatum: PyramidNodeDatum): _ModuleSupport.TooltipContent | undefined;
    getSeriesDomain(): any[];
    getSeriesRange(_direction: _ModuleSupport.ChartAxisDirection, _visibleRange: [any, any]): [number, number];
    pickNodeClosestDatum({ x, y }: _ModuleSupport.Point): _ModuleSupport.SeriesNodePickMatch | undefined;
    private legendItemSymbol;
    getLegendData(legendType: _ModuleSupport.ChartLegendType): _ModuleSupport.CategoryLegendDatum[];
}
export {};
