import { type FillOptions, type LineDashOptions, type StrokeOptions, _ModuleSupport } from 'ag-charts-community';
import { type FlowProportionLinkDatum, type FlowProportionNodeDatum, FlowProportionSeries, type FlowProportionSeriesContext } from '../flow-proportion/flowProportionSeries';
import { ChordLink } from './chordLink';
import { ChordSeriesProperties } from './chordSeriesProperties';
interface ChordNodeDatum extends FlowProportionNodeDatum<ChordNodeDatum, ChordLinkDatum> {
    centerX: number;
    centerY: number;
    innerRadius: number;
    outerRadius: number;
    startAngle: number;
    endAngle: number;
}
interface ChordLinkDatum extends FlowProportionLinkDatum<ChordNodeDatum, ChordLinkDatum> {
    centerX: number;
    centerY: number;
    radius: number;
    startAngle1: number;
    endAngle1: number;
    startAngle2: number;
    endAngle2: number;
}
type ChordDatum = ChordLinkDatum | ChordNodeDatum;
interface ChordNodeLabelDatum {
    id: string;
    text: string;
    centerX: number;
    centerY: number;
    angle: number;
    radius: number;
}
type NodeStyle = Pick<FillOptions & StrokeOptions & LineDashOptions, 'fill' | 'stroke'> & Omit<Required<FillOptions & StrokeOptions & LineDashOptions>, 'fill' | 'stroke'>;
type LinkStyle = NodeStyle & {
    tension: number;
};
interface ChordNodeDataContext extends FlowProportionSeriesContext<ChordNodeDatum, ChordLinkDatum, ChordNodeLabelDatum> {
}
export declare class ChordSeries extends FlowProportionSeries<ChordNodeDatum, ChordLinkDatum, ChordNodeLabelDatum, ChordSeriesProperties, _ModuleSupport.Sector, ChordLink> {
    static readonly className = "ChordSeries";
    static readonly type: "chord";
    properties: ChordSeriesProperties;
    constructor(moduleCtx: _ModuleSupport.ModuleContext);
    private isLabelEnabled;
    protected linkFactory(): ChordLink<any>;
    protected nodeFactory(): _ModuleSupport.Sector<any>;
    createNodeData(): ChordNodeDataContext | undefined;
    protected updateLabelSelection(opts: {
        labelData: ChordNodeLabelDatum[];
        labelSelection: _ModuleSupport.Selection<_ModuleSupport.TransformableText, ChordNodeLabelDatum>;
    }): _ModuleSupport.Selection<_ModuleSupport.TransformableText, ChordNodeLabelDatum>;
    protected updateLabelNodes(opts: {
        labelSelection: _ModuleSupport.Selection<_ModuleSupport.TransformableText, ChordNodeLabelDatum>;
    }): void;
    protected updateNodeSelection(opts: {
        nodeData: ChordNodeDatum[];
        datumSelection: _ModuleSupport.Selection<_ModuleSupport.Sector, ChordNodeDatum>;
    }): _ModuleSupport.Selection<_ModuleSupport.Sector<any>, ChordNodeDatum>;
    protected getBaseNodeStyle(highlighted: boolean): NodeStyle;
    protected getNodeStyleOverrides(datumId: string, datum: any, datumIndex: number, size: number, label: string | undefined, format: NodeStyle, highlighted: boolean): Partial<NodeStyle>;
    protected updateNodeNodes(opts: {
        datumSelection: _ModuleSupport.Selection<_ModuleSupport.Sector, ChordNodeDatum>;
        isHighlight: boolean;
    }): void;
    protected updateLinkSelection(opts: {
        nodeData: ChordLinkDatum[];
        datumSelection: _ModuleSupport.Selection<ChordLink, ChordLinkDatum>;
    }): _ModuleSupport.Selection<ChordLink<any>, ChordLinkDatum>;
    protected getBaseLinkStyle(highlighted: boolean): LinkStyle;
    protected getLinkStyleOverrides(datumId: string, datum: any, fromNodeDatumIndex: number, format: LinkStyle, highlighted: boolean): Partial<LinkStyle>;
    protected updateLinkNodes(opts: {
        datumSelection: _ModuleSupport.Selection<ChordLink, ChordLinkDatum>;
        isHighlight: boolean;
    }): void;
    getTooltipContent(seriesDatum: ChordDatum): _ModuleSupport.TooltipContent | undefined;
    protected computeFocusBounds(node: _ModuleSupport.Sector | ChordLink): _ModuleSupport.BBox | _ModuleSupport.Path | undefined;
}
export {};
