export declare class LicenseManager {
    private static readonly RELEASE_INFORMATION;
    private static licenseKey?;
    private static gridContext;
    private watermarkMessage;
    private readonly md5;
    private readonly document?;
    private readonly totalMessageLength;
    constructor(document?: Document);
    validateLicense(): void;
    private static extractExpiry;
    private static extractLicenseComponents;
    getLicenseDetails(licenseKey: string, gridContext?: boolean): {
        licenseKey: never;
        valid: boolean;
        missing: boolean;
        currentLicenseType: string;
        incorrectLicenseType?: undefined;
        suppliedLicenseType?: undefined;
        expiry?: undefined;
        expired?: undefined;
        version?: undefined;
        isTrial?: undefined;
        trialExpired?: undefined;
        invalidLicenseTypeForCombo?: undefined;
    } | {
        licenseKey: string;
        valid: false;
        incorrectLicenseType: boolean;
        currentLicenseType: string;
        suppliedLicenseType: string | undefined;
        missing?: undefined;
        expiry?: undefined;
        expired?: undefined;
        version?: undefined;
        isTrial?: undefined;
        trialExpired?: undefined;
        invalidLicenseTypeForCombo?: undefined;
    } | {
        licenseKey: string;
        valid: true;
        expiry: string;
        expired: boolean | undefined;
        version: string | null;
        isTrial: boolean | null;
        trialExpired: undefined;
        invalidLicenseTypeForCombo: boolean | undefined;
        incorrectLicenseType: boolean;
        currentLicenseType: string;
        suppliedLicenseType: string | undefined;
        missing?: undefined;
    };
    isDisplayWatermark(): boolean;
    getWatermarkMessage(): string;
    private getHostname;
    private isForceWatermark;
    private isWebsiteUrl;
    private isLocalhost;
    private static formatDate;
    private static getChartsReleaseDate;
    private static decode;
    private static utf8_decode;
    static setGridContext(gridContext?: boolean): void;
    static setLicenseKey(licenseKey?: string): void;
    private static extractBracketedInformation;
    private centerPadAndOutput;
    private padAndOutput;
    private outputInvalidLicenseKey;
    private outputExpiredTrialKey;
    private outputMissingLicenseKey;
    private outputExpiredKey;
}
