import type { FontFamily, FontSize, FontStyle, FontWeight, Ratio } from 'ag-charts-types';
export type Writeable<T> = {
    -readonly [P in keyof T]: T[P];
};
export interface FontOptions {
    fontSize?: FontSize;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    fontFamily?: FontFamily;
    lineHeight?: Ratio;
}
export interface MeasureOptions {
    font: string | FontOptions;
    textAlign?: CanvasTextAlign;
    textBaseline?: CanvasTextBaseline;
}
export interface LineMetrics {
    width: number;
    height: number;
    offsetTop: number;
    offsetLeft: number;
    lineHeight: number;
}
export interface MultilineMetrics {
    width: number;
    height: number;
    offsetTop: number;
    offsetLeft: number;
    lineMetrics: ({
        text: string;
    } & LineMetrics)[];
}
export interface LegacyTextMetrics extends Writeable<TextMetrics> {
    emHeightAscent: number;
    emHeightDescent: number;
}
export interface TextMeasurer {
    textWidth(text: string, estimate?: boolean): number;
    measureText(text: string): LineMetrics;
    measureLines(text: string | string[]): MultilineMetrics;
}
export declare class CachedTextMeasurerPool {
    private static readonly instanceMap;
    static measureText(text: string, options: MeasureOptions): LineMetrics;
    static measureLines(text: string | string[], options: MeasureOptions): MultilineMetrics;
    static getMeasurer(options: MeasureOptions): CachedTextMeasurer;
    private static createFontMeasurer;
}
export declare class CachedTextMeasurer implements TextMeasurer {
    private readonly ctx;
    private readonly measureMap;
    private readonly textMeasurer;
    constructor(ctx: CanvasRenderingContext2D, options: MeasureOptions);
    textWidth(text: string, estimate?: boolean): number;
    measureText(text: string): LineMetrics;
    measureLines(text: string | string[]): MultilineMetrics;
    private cachedCtxMeasureText;
}
export declare class TextUtils {
    static readonly EllipsisChar = "\u2026";
    static readonly defaultLineHeight = 1.15;
    static readonly lineSplitter: RegExp;
    static toFontString({ fontSize, fontStyle, fontWeight, fontFamily, lineHeight }: FontOptions): string;
    static getLineHeight(fontSize: number): number;
    static getVerticalModifier(textBaseline?: CanvasTextBaseline): number;
}
export declare class SimpleTextMeasurer implements TextMeasurer {
    private readonly measureTextFn;
    private readonly textBaseline;
    private readonly charMap;
    constructor(measureTextFn: (text: string) => LegacyTextMetrics, textBaseline?: CanvasTextBaseline);
    private getMetrics;
    private getMultilineMetrics;
    textWidth(text: string, estimate?: boolean): number;
    measureText(text: string): LineMetrics;
    measureLines(text: string | string[]): MultilineMetrics;
    private charWidth;
}
