import type { TimeInterval } from '../util/time';
import { BandScale } from './bandScale';
import type { NormalizedDomain, ScaleFormatParams, ScaleTickParams } from './scale';
export declare class OrdinalTimeScale extends BandScale<Date, TimeInterval | number> {
    readonly type = "ordinal-time";
    static is(value: unknown): value is OrdinalTimeScale;
    private _domain;
    private sortedTimestamps;
    private isReversed;
    private precomputedSteps;
    set domain(domain: Date[]);
    get domain(): Date[];
    toDomain(value: number): Date;
    normalizeDomains(...domains: Date[][]): NormalizedDomain<Date>;
    ticks({ interval, maxTickCount }: ScaleTickParams<TimeInterval | number>, domain?: Date[], visibleRange?: [number, number]): Date[];
    private getSortedTimestamps;
    private getPrecomputedSteps;
    private findIntervalInRange;
    private findInterval;
    /**
     * Returns a time format function suitable for displaying tick values.
     * @param specifier If the specifier string is provided, this method is equivalent to
     * the {@link TimeLocaleObject.format} method.
     * If no specifier is provided, this method returns the default time format function.
     */
    tickFormatter({ domain, ticks, specifier }: ScaleFormatParams<Date>): (date: Date) => string;
    datumFormatter(params: ScaleFormatParams<Date>): (date: Date) => string;
    invert(position: number, nearest?: boolean): Date | undefined;
    protected getIndex(value: Date): number | undefined;
}
