import { type DeepPartial } from 'ag-charts-core';
import { type AgChartOptions, type AgChartThemeParams } from 'ag-charts-types';
import { PRESETS } from '../api/preset/presets';
import { type ChartTheme } from '../chart/themes/chartTheme';
export interface ChartSpecialOverrides {
    document: Document;
    window: Window;
    sceneMode?: 'simple';
    styleContainer?: HTMLElement;
}
export interface ChartInternalOptionMetadata {
    presetType?: keyof typeof PRESETS;
    pool?: boolean;
}
export declare class ChartOptions<T extends AgChartOptions = AgChartOptions> {
    private static readonly OPTIONS_CLONE_OPTS;
    private static readonly FAST_PATH_OPTIONS;
    private static isFastPathDelta;
    activeTheme: ChartTheme;
    processedOptions: T;
    defaultAxes: T;
    userOptions: Partial<T>;
    processedOverrides: Partial<T>;
    specialOverrides: ChartSpecialOverrides;
    optionMetadata: ChartInternalOptionMetadata;
    themeParameters: AgChartThemeParams;
    annotationThemes: any;
    fastDelta?: DeepPartial<T>;
    private readonly debug;
    constructor(userOptions: T | ChartOptions<T>, processedOverrides: Partial<T>, specialOverrides: Partial<ChartSpecialOverrides>, metadata: ChartInternalOptionMetadata, deltaOptions?: DeepPartial<T>, stripSymbols?: boolean);
    private fastSetup;
    private fastSeriesSetup;
    private slowSetup;
    diffOptions(other?: ChartOptions): Partial<T>;
    private getSeriesThemeConfig;
    private getDefaultAxes;
    private optionsType;
    private sanityCheck;
    private splitAnnotationsOptions;
    private processAxesOptions;
    private processSeriesOptions;
    private processMiniChartSeriesOptions;
    private getThemeParameters;
    private resolveThemeOperations;
    private getSeriesPalette;
    private getSeriesGroupingOptions;
    private setSeriesGroupingOptions;
    private getSeriesGroupId;
    private getSeriesGrouping;
    private getDefaultSeriesType;
    private getTooltipPositionDefaults;
    private getTooltipRangeDefaults;
    private axesTypeIntegrity;
    private seriesTypeIntegrity;
    private soloSeriesIntegrity;
    private static enableConfiguredJsonOptions;
    private static cleanupEnabledFromThemeJsonOptions;
    private enableConfiguredOptions;
    private static removeDisabledOptionJson;
    private removeDisabledOptions;
    private static removeLeftoverSymbolsJson;
    private removeLeftoverSymbols;
    private specialOverridesDefaults;
}
