import { type EventListener } from 'ag-charts-core';
import { ChartUpdateType } from './chartUpdateType';
import type { ISeries } from './series/seriesTypes';
export type UpdateCallback = (type: ChartUpdateType, opts?: UpdateOpts) => void;
export interface UpdateCompleteEvent {
    readonly type: 'update-complete';
}
export interface PreDomUpdateEvent {
    readonly type: 'pre-dom-update';
}
export interface PreSceneRenderEvent {
    readonly type: 'pre-scene-render';
}
export interface ProcessDataEvent {
    readonly type: 'process-data';
    readonly series: {
        shouldFlipXY?: boolean;
    };
}
export type UpdateOpts = {
    forceNodeDataRefresh?: boolean;
    skipAnimations?: boolean;
    newAnimationBatch?: boolean;
    seriesToUpdate?: Iterable<ISeries<any, any>>;
    backOffMs?: number;
    skipSync?: boolean;
};
interface EventMap {
    'update-complete': UpdateCompleteEvent;
    'pre-dom-update': PreDomUpdateEvent;
    'pre-scene-render': PreSceneRenderEvent;
    'process-data': ProcessDataEvent;
}
export declare class UpdateService {
    private readonly updateCallback;
    private readonly events;
    constructor(updateCallback: UpdateCallback);
    addListener<K extends keyof EventMap>(eventName: K, listener: EventListener<EventMap[K]>): () => void;
    removeListener<K extends keyof EventMap>(eventName: K, listener: EventListener<EventMap[K]>): () => void;
    destroy(): void;
    update(type?: ChartUpdateType, options?: UpdateOpts): void;
    dispatchUpdateComplete(): void;
    dispatchPreDomUpdate(): void;
    dispatchPreSceneRender(): void;
    dispatchProcessData({ series }: {
        series: {
            shouldFlipXY?: boolean;
        };
    }): void;
}
export {};
