import type { AgChartTheme, AgChartThemePalette, AgChartThemeParams, AgPaletteColors, AgPresetOverrides, WithThemeParams } from 'ag-charts-types';
import { type PaletteType } from '../../module/coreModulesTypes';
import { CARTESIAN_POSITION, FONT_SIZE_RATIO } from './constants';
import { type DefaultColors } from './defaultColors';
export declare class ChartTheme {
    readonly palette: Required<AgChartThemePalette> & {
        altUp: AgPaletteColors;
        altDown: AgPaletteColors;
        altNeutral: AgPaletteColors;
    };
    readonly paletteType: PaletteType;
    readonly config: any;
    readonly presets: AgPresetOverrides;
    private static getAxisDefaults;
    protected getChartDefaults(): {
        minHeight: number;
        minWidth: number;
        background: {
            visible: boolean;
            fill: {
                $ref: string;
            };
        };
        padding: {
            top: {
                $ref: string;
            };
            right: {
                $ref: string;
            };
            bottom: {
                $ref: string;
            };
            left: {
                $ref: string;
            };
        };
        seriesArea: {
            padding: {
                top: number;
                right: number;
                bottom: number;
                left: number;
            };
        };
        keyboard: {
            enabled: boolean;
        };
        title: {
            enabled: boolean;
            text: string;
            fontWeight: {
                $ref: string;
            };
            fontSize: {
                $rem: FONT_SIZE_RATIO[];
            };
            fontFamily: {
                $ref: string;
            };
            color: {
                $ref: string;
            };
            wrapping: string;
            layoutStyle: string;
            textAlign: string;
        };
        subtitle: {
            enabled: boolean;
            text: string;
            spacing: number;
            fontWeight: {
                $ref: string;
            };
            fontSize: {
                $rem: FONT_SIZE_RATIO[];
            };
            fontFamily: {
                $ref: string;
            };
            color: {
                $ref: string;
            };
            wrapping: string;
            layoutStyle: string;
            textAlign: string;
        };
        footnote: {
            enabled: boolean;
            text: string;
            spacing: number;
            fontSize: {
                $rem: FONT_SIZE_RATIO[];
            };
            fontFamily: {
                $ref: string;
            };
            fontWeight: {
                $ref: string;
            };
            color: {
                $ref: string;
            };
            wrapping: string;
            layoutStyle: string;
            textAlign: string;
        };
        legend: {
            position: CARTESIAN_POSITION;
            spacing: number;
            listeners: {};
            toggleSeries: boolean;
            item: {
                paddingX: number;
                paddingY: number;
                marker: {
                    size: number;
                    padding: number;
                };
                showSeriesStroke: boolean;
                label: {
                    color: {
                        $ref: string;
                    };
                    fontSize: {
                        $ref: string;
                    };
                    fontFamily: {
                        $ref: string;
                    };
                    fontWeight: {
                        $ref: string;
                    };
                };
            };
            reverseOrder: boolean;
            pagination: {
                marker: {
                    size: number;
                };
                activeStyle: {
                    fill: {
                        $ref: string;
                    };
                };
                inactiveStyle: {
                    fill: {
                        $ref: string;
                    };
                };
                highlightStyle: {
                    fill: {
                        $ref: string;
                    };
                };
                label: {
                    color: {
                        $ref: string;
                    };
                };
            };
        };
        tooltip: {
            enabled: boolean;
            darkTheme: boolean;
            delay: number;
        };
        overlays: {
            darkTheme: boolean;
        };
        listeners: {};
    };
    private static readonly cartesianAxisDefault;
    constructor(options?: AgChartTheme);
    private mergeOverrides;
    private createChartConfigPerChartType;
    private getDefaults;
    private static applyTemplateTheme;
    templateTheme<T>(themeTemplate: T, clone?: boolean): T;
    protected getDefaultColors(): DefaultColors;
    getPublicParameters(): Required<WithThemeParams<AgChartThemeParams>>;
    getTemplateParameters(): Map<any, any>;
}
