import type { AgPieSeriesStyle } from 'ag-charts-types';
import type { ModuleContext } from '../../../module/moduleContext';
import { BBox } from '../../../scene/bbox';
import { Group, TranslatableGroup } from '../../../scene/group';
import { Node } from '../../../scene/node';
import type { Point } from '../../../scene/point';
import { Sector } from '../../../scene/shape/sector';
import { ChartAxisDirection } from '../../chartAxisDirection';
import type { DataController } from '../../data/dataController';
import type { CategoryLegendDatum, ChartLegendType } from '../../legend/legendDatum';
import { Marker } from '../../marker/marker';
import { type TooltipContent } from '../../tooltip/tooltip';
import type { DataModelSeriesNodeDatum } from '../dataModelSeries';
import { SeriesNodeEvent, type SeriesNodeEventTypes, type SeriesNodePickMatch } from '../series';
import { PieSeriesProperties } from './pieSeriesProperties';
import { type PolarAnimationData, PolarSeries } from './polarSeries';
declare class PieSeriesNodeEvent<TEvent extends string = SeriesNodeEventTypes> extends SeriesNodeEvent<PieNodeDatum, TEvent> {
    readonly angleKey: string;
    readonly radiusKey?: string;
    readonly calloutLabelKey?: string;
    readonly sectorLabelKey?: string;
    constructor(type: TEvent, nativeEvent: Event, datum: PieNodeDatum, series: PieSeries);
}
interface PieCalloutLabelDatum {
    readonly text: string;
    readonly textAlign: CanvasTextAlign;
    readonly textBaseline: CanvasTextBaseline;
    hidden: boolean;
    collisionTextAlign?: CanvasTextAlign;
    collisionOffsetY: number;
    box?: BBox;
}
interface PieNodeDatum extends DataModelSeriesNodeDatum {
    readonly radius: number;
    readonly innerRadius: number;
    readonly outerRadius: number;
    readonly angleValue: number;
    readonly radiusValue?: number;
    readonly startAngle: number;
    readonly endAngle: number;
    readonly midAngle: number;
    readonly midCos: number;
    readonly midSin: number;
    readonly calloutLabel?: PieCalloutLabelDatum;
    readonly sectorLabel?: {
        readonly text: string;
    };
    readonly sectorFormat: {
        [key in keyof Required<AgPieSeriesStyle>]: AgPieSeriesStyle[key];
    };
    readonly legendItem?: {
        key: string;
        text: string;
    };
    readonly legendItemValue?: string;
    enabled: boolean;
}
export declare class PieSeries extends PolarSeries<PieNodeDatum, PieSeriesProperties, Sector> {
    static readonly className = "PieSeries";
    static readonly type: "pie";
    properties: PieSeriesProperties;
    private phantomNodeData;
    private get calloutNodeData();
    readonly backgroundGroup: TranslatableGroup;
    private readonly previousRadiusScale;
    private readonly radiusScale;
    protected phantomGroup: Group<any>;
    private readonly phantomSelection;
    private readonly calloutLabelGroup;
    private readonly calloutLabelSelection;
    readonly zerosumRingsGroup: Group<any>;
    readonly zerosumOuterRing: Marker;
    private readonly angleScale;
    private oldTitle?;
    surroundingRadius?: number;
    constructor(moduleCtx: ModuleContext);
    attachSeries(seriesContentNode: Node, seriesNode: Node, annotationNode: Node | undefined): void;
    detachSeries(seriesContentNode: Node | undefined, seriesNode: Node, annotationNode: Node | undefined): void;
    setSeriesIndex(index: number): boolean;
    protected nodeFactory(): Sector;
    getSeriesDomain(direction: ChartAxisDirection): any[];
    processData(dataController: DataController): Promise<void>;
    maybeRefreshNodeData(): void;
    private getProcessedDataValues;
    createNodeData(): {
        itemId: string;
        nodeData: PieNodeDatum[];
        labelData: PieNodeDatum[];
        phantomNodeData: PieNodeDatum[] | undefined;
    } | undefined;
    private getLabels;
    private getTextAlignment;
    private getSectorFormat;
    getOuterRadius(): number;
    updateRadiusScale(resize: boolean): void;
    private getTitleTranslationY;
    update({ seriesRect }: {
        seriesRect: BBox;
    }): void;
    private updateTitleNodes;
    private updateNodeMidPoint;
    private updateSelections;
    private updateNodes;
    updateCalloutLineNodes(): void;
    private getLabelOverflow;
    private bboxIntersectsSurroundingSeries;
    private computeCalloutLabelCollisionOffsets;
    private updateCalloutLabelNodes;
    computeLabelsBBox(options: {
        hideWhenNecessary: boolean;
    }, seriesRect: BBox): BBox | null;
    private updateSectorLabelNodes;
    private updateZerosumRings;
    protected readonly NodeEvent: typeof PieSeriesNodeEvent;
    protected pickNodeClosestDatum(point: Point): SeriesNodePickMatch | undefined;
    getTooltipContent(nodeDatum: PieNodeDatum): TooltipContent | undefined;
    private legendItemSymbol;
    getLegendData(legendType: ChartLegendType): CategoryLegendDatum[];
    setLegendState(enabledItems: boolean[]): void;
    animateEmptyUpdateReady(_data?: PolarAnimationData): void;
    animateWaitingUpdateReady(): void;
    animateClearingUpdateEmpty(): void;
    getDatumId(datum: any, datumIndex: number): any;
}
export {};
