import type { ModuleContext } from '../../../module/moduleContext';
import { ColorScale } from '../../../scale/colorScale';
import type { BBox } from '../../../scene/bbox';
import { Group } from '../../../scene/group';
import type { Selection } from '../../../scene/selection';
import { Text } from '../../../scene/shape/text';
import type { PlacedLabel } from '../../../scene/util/labelPlacement';
import { ChartAxisDirection } from '../../chartAxisDirection';
import type { DataController } from '../../data/dataController';
import type { CategoryLegendDatum, ChartLegendType } from '../../legend/legendDatum';
import { Marker } from '../../marker/marker';
import { type TooltipContent } from '../../tooltip/tooltip';
import { type PickFocusInputs } from '../series';
import type { CartesianAnimationData } from './cartesianSeries';
import { CartesianSeries } from './cartesianSeries';
import { type ScatterNodeDatum, ScatterSeriesProperties } from './scatterSeriesProperties';
type ScatterAnimationData = CartesianAnimationData<Group, ScatterNodeDatum>;
export declare class ScatterSeries extends CartesianSeries<Group, ScatterSeriesProperties, ScatterNodeDatum> {
    static readonly className = "ScatterSeries";
    static readonly type: "scatter";
    protected clipFocusBox: boolean;
    properties: ScatterSeriesProperties;
    readonly colorScale: ColorScale;
    get pickModeAxis(): "main-category";
    constructor(moduleCtx: ModuleContext);
    processData(dataController: DataController): Promise<void>;
    xCoordinateRange(xValue: any, pixelSize: number): [number, number];
    yCoordinateRange(yValues: any[], pixelSize: number): [number, number];
    getSeriesDomain(direction: ChartAxisDirection): any[];
    getSeriesRange(_direction: ChartAxisDirection, visibleRange: [any, any]): any[];
    getVisibleItems(xVisibleRange: [number, number], yVisibleRange: [number, number], minVisibleItems: number): number;
    createNodeData(): {
        itemId: string;
        nodeData: ScatterNodeDatum[];
        labelData: ScatterNodeDatum[];
        scales: {
            x?: import("./scaling").Scaling | undefined;
            y?: import("./scaling").Scaling | undefined;
        };
        visible: boolean;
    } | undefined;
    protected isPathOrSelectionDirty(): boolean;
    getLabelData(): ScatterNodeDatum[];
    protected updateMarkerSelection(opts: {
        nodeData: ScatterNodeDatum[];
        markerSelection: Selection<Marker, ScatterNodeDatum>;
    }): Selection<Marker, ScatterNodeDatum>;
    private getMarkerItemBaseStyle;
    private getMarkerItemStyleOverrides;
    protected updateMarkerNodes(opts: {
        markerSelection: Selection<Marker, ScatterNodeDatum>;
        isHighlight: boolean;
    }): void;
    updatePlacedLabelData(labelData: PlacedLabel<ScatterNodeDatum>[]): void;
    protected updateLabelNodes(opts: {
        labelSelection: Selection<Text, ScatterNodeDatum>;
    }): void;
    getTooltipContent(nodeDatum: ScatterNodeDatum): TooltipContent | undefined;
    private legendItemSymbol;
    getLegendData(legendType: ChartLegendType): CategoryLegendDatum[];
    animateEmptyUpdateReady(data: ScatterAnimationData): void;
    protected isLabelEnabled(): boolean;
    protected nodeFactory(): Group<any>;
    getFormattedMarkerStyle(datum: ScatterNodeDatum): import("ag-charts-types").AgSeriesMarkerStyle & {
        size: number;
    };
    protected computeFocusBounds(opts: PickFocusInputs): BBox | undefined;
}
export {};
