import type { AnimationValue } from '../../../motion/animation';
import type { Scale } from '../../../scale/scale';
import { BBox } from '../../../scene/bbox';
import { Group, TranslatableGroup } from '../../../scene/group';
import type { Node, NodeWithOpacity } from '../../../scene/node';
import type { Point } from '../../../scene/point';
import { Selection } from '../../../scene/selection';
import { Path } from '../../../scene/shape/path';
import { Text } from '../../../scene/shape/text';
import { QuadtreeNearest } from '../../../scene/util/quadtree';
import { StateMachine } from '../../../util/stateMachine';
import type { ChartAnimationPhase } from '../../chartAnimationPhase';
import { ChartAxisDirection } from '../../chartAxisDirection';
import { Marker } from '../../marker/marker';
import { DataModelSeries, type DataModelSeriesNodeDataContext, type DataModelSeriesNodeDatum } from '../dataModelSeries';
import type { SeriesConstructorOpts, SeriesDirectionKeysMapping, SeriesNodeEventTypes, SeriesNodePickMatch } from '../series';
import { SeriesNodeEvent } from '../series';
import { SeriesProperties } from '../seriesProperties';
import type { ISeries, SeriesNodeDatum } from '../seriesTypes';
import type { Scaling } from './scaling';
export interface CartesianSeriesNodeDatum extends DataModelSeriesNodeDatum {
    readonly xKey: string;
    readonly yKey?: string;
    readonly xValue?: any;
    readonly yValue?: any;
}
type CartesianSeriesOpts<TNode extends Node<TDatum>, TProps extends CartesianSeriesProperties<any>, TDatum extends CartesianSeriesNodeDatum, TLabel extends SeriesNodeDatum<number>> = {
    pathsPerSeries: string[];
    pathsZIndexSubOrderOffset: number[];
    hasMarkers: boolean;
    hasHighlightedLabels: boolean;
    directionKeys: SeriesDirectionKeysMapping<TProps>;
    directionNames: SeriesDirectionKeysMapping<TProps>;
    datumSelectionGarbageCollection: boolean;
    markerSelectionGarbageCollection: boolean;
    animationAlwaysUpdateSelections: boolean;
    animationResetFns?: {
        path?: (path: Path<TDatum>) => Partial<Path<TDatum>>;
        datum?: (node: TNode, datum: TDatum) => AnimationValue & Partial<TNode>;
        label?: (node: Text, datum: TLabel) => AnimationValue & Partial<Text>;
        marker?: (node: Marker, datum: TDatum) => AnimationValue & Partial<Marker>;
    };
};
export declare const DEFAULT_CARTESIAN_DIRECTION_KEYS: {
    x: "xKey"[];
    y: "yKey"[];
};
export declare const DEFAULT_CARTESIAN_DIRECTION_NAMES: {
    x: "xName"[];
    y: "yName"[];
};
export declare class CartesianSeriesNodeEvent<TEvent extends string = SeriesNodeEventTypes> extends SeriesNodeEvent<SeriesNodeDatum<number>, TEvent> {
    readonly xKey?: string;
    readonly yKey?: string;
    constructor(type: TEvent, nativeEvent: Event, datum: SeriesNodeDatum<number>, series: ISeries<SeriesNodeDatum<number>, {
        xKey?: string;
        yKey?: string;
    }>);
}
type CartesianAnimationState = 'empty' | 'ready' | 'waiting' | 'clearing' | 'disabled';
type CartesianAnimationEvent<TNode extends Node, TDatum extends CartesianSeriesNodeDatum, TLabel extends SeriesNodeDatum<number> = TDatum, TContext extends CartesianSeriesNodeDataContext<TDatum, TLabel> = CartesianSeriesNodeDataContext<TDatum, TLabel>> = {
    update: CartesianAnimationData<TNode, TDatum, TLabel, TContext>;
    updateData: undefined;
    highlight: Selection<TNode, TDatum>;
    highlightMarkers: Selection<Marker, TDatum>;
    resize: CartesianAnimationData<TNode, TDatum, TLabel, TContext>;
    clear: CartesianAnimationData<TNode, TDatum, TLabel, TContext>;
    reset: undefined;
    skip: undefined;
    disable: undefined;
};
export interface CartesianAnimationData<TNode extends Node, TDatum extends CartesianSeriesNodeDatum, TLabel extends SeriesNodeDatum<number> = TDatum, TContext extends CartesianSeriesNodeDataContext<TDatum, TLabel> = CartesianSeriesNodeDataContext<TDatum, TLabel>> {
    datumSelection: Selection<TNode, TDatum>;
    markerSelection: Selection<Marker, TDatum>;
    labelSelection: Selection<Text, TLabel>;
    annotationSelections: Selection<NodeWithOpacity, TDatum>[];
    contextData: TContext;
    previousContextData?: TContext;
    paths: Path[];
    seriesRect?: BBox;
    duration?: number;
}
export declare abstract class CartesianSeriesProperties<T extends object> extends SeriesProperties<T> {
    legendItemName?: string;
    pickOutsideVisibleMinorAxis: boolean;
}
export interface CartesianSeriesNodeDataContext<TDatum extends CartesianSeriesNodeDatum = CartesianSeriesNodeDatum, TLabel extends SeriesNodeDatum<number> = TDatum> extends DataModelSeriesNodeDataContext<TDatum, TLabel> {
    scales: {
        [key in ChartAxisDirection]?: Scaling;
    };
    animationValid?: boolean;
    visible: boolean;
}
export declare const RENDER_TO_OFFSCREEN_CANVAS_THRESHOLD = 100;
export declare abstract class CartesianSeries<TNode extends Node, TProps extends CartesianSeriesProperties<any>, TDatum extends CartesianSeriesNodeDatum, TLabel extends SeriesNodeDatum<number> = TDatum, TContext extends CartesianSeriesNodeDataContext<TDatum, TLabel> = CartesianSeriesNodeDataContext<TDatum, TLabel>> extends DataModelSeries<TDatum, TProps, TLabel, TContext> {
    private _contextNodeData?;
    get contextNodeData(): TContext | undefined;
    getNodeData(): TDatum[] | undefined;
    protected readonly NodeEvent: typeof CartesianSeriesNodeEvent;
    private readonly paths;
    protected readonly dataNodeGroup: Group<any>;
    protected readonly markerGroup: Group<any>;
    readonly labelGroup: TranslatableGroup;
    private datumSelection;
    private markerSelection;
    protected labelSelection: Selection<Text, TLabel>;
    private highlightSelection;
    private highlightLabelSelection;
    annotationSelections: Set<Selection<NodeWithOpacity, TDatum>>;
    private readonly opts;
    private readonly debug;
    protected quadtree?: QuadtreeNearest<TDatum>;
    protected animationState: StateMachine<CartesianAnimationState, CartesianAnimationEvent<TNode, TDatum, TLabel, TContext>>;
    protected constructor({ pathsPerSeries, hasMarkers, hasHighlightedLabels, pathsZIndexSubOrderOffset, datumSelectionGarbageCollection, markerSelectionGarbageCollection, animationAlwaysUpdateSelections, animationResetFns, directionKeys, directionNames, ...otherOpts }: Partial<CartesianSeriesOpts<TNode, TProps, TDatum, TLabel>> & Pick<CartesianSeriesOpts<TNode, TProps, TDatum, TLabel>, 'directionKeys' | 'directionNames'> & SeriesConstructorOpts<TProps>);
    attachSeries(seriesContentNode: Node, seriesNode: Node, annotationNode: Node | undefined): void;
    detachSeries(seriesContentNode: Node | undefined, seriesNode: Node, annotationNode: Node | undefined): void;
    protected attachPaths(paths: Path[], _seriesNode: Node, _annotationNode: Node | undefined): void;
    protected detachPaths(paths: Path[], _seriesNode: Node, _annotationNode: Node | undefined): void;
    renderToOffscreenCanvas(): boolean;
    resetAnimation(phase: ChartAnimationPhase): void;
    addChartEventListeners(): void;
    destroy(): void;
    update({ seriesRect }: {
        seriesRect?: BBox;
    }): void;
    protected updateSelections(anySeriesItemEnabled: boolean): void;
    private updateSeriesSelections;
    protected abstract nodeFactory(): TNode;
    protected updateNodes(highlightedItems: TDatum[] | undefined, seriesHighlighted: boolean, anySeriesItemEnabled: boolean): void;
    protected getHighlightLabelData(labelData: TLabel[], highlightedItem: TDatum): TLabel[] | undefined;
    protected getHighlightData(_nodeData: TDatum[], highlightedItem: TDatum): TDatum[] | undefined;
    protected updateHighlightSelection(seriesHighlighted: boolean): TDatum[] | undefined;
    protected markQuadtreeDirty(): void;
    protected datumNodesIter(): Iterable<TNode>;
    getQuadTree(): QuadtreeNearest<TDatum>;
    protected initQuadTree(_quadtree: QuadtreeNearest<TDatum>): void;
    protected pickNodeExactShape(point: Point): SeriesNodePickMatch | undefined;
    protected pickNodeClosestDatum(point: Point): SeriesNodePickMatch | undefined;
    protected pickNodeMainAxisFirst(point: Point, requireCategoryAxis: boolean): SeriesNodePickMatch | undefined;
    protected isPathOrSelectionDirty(): boolean;
    shouldFlipXY(): boolean;
    protected abstract xCoordinateRange(xValue: any, pixelSize: number, index: number): [number, number];
    protected abstract yCoordinateRange(yValues: any[], pixelSize: number, index: number): [number, number];
    private keysOrValues;
    protected visibleRange(axisKey: string, visibleRange: [any, any], indices?: number[]): [number, number];
    protected domainForVisibleRange(_direction: ChartAxisDirection, axisKeys: string[], crossAxisKey: string, visibleRange: [any, any], sorted: boolean, indices?: number[]): number[];
    protected domainForClippedRange(direction: ChartAxisDirection, axisKeys: string[], crossAxisKey: string, sorted: boolean): any[];
    protected countVisibleItems(crossAxisKey: string, axisKeys: string[], xVisibleRange: [number, number], yVisibleRange: [number, number], minVisibleItems: number): number;
    protected updateHighlightSelectionItem(opts: {
        items?: TDatum[];
        highlightSelection: Selection<TNode, TDatum>;
    }): Selection<TNode, TDatum>;
    protected updateHighlightSelectionLabel(opts: {
        items?: TLabel[];
        highlightLabelSelection: Selection<Text, TLabel>;
    }): Selection<Text<any>, TLabel>;
    protected updateDatumSelection(opts: {
        nodeData: TDatum[];
        datumSelection: Selection<TNode, TDatum>;
    }): Selection<TNode, TDatum>;
    protected updateDatumNodes(_opts: {
        datumSelection: Selection<TNode, TDatum>;
        highlightedItems?: TDatum[];
        isHighlight: boolean;
    }): void;
    protected updateMarkerSelection(opts: {
        nodeData: TDatum[];
        markerSelection: Selection<Marker, TDatum>;
    }): Selection<Marker, TDatum>;
    protected updateMarkerNodes(_opts: {
        markerSelection: Selection<Marker, TDatum>;
        isHighlight: boolean;
    }): void;
    protected updatePaths(opts: {
        seriesHighlighted?: boolean;
        itemId?: string;
        contextData: TContext;
        paths: Path[];
    }): void;
    protected updatePathNodes(opts: {
        seriesHighlighted?: boolean;
        itemId?: string;
        paths: Path[];
        opacity: number;
        visible: boolean;
        animationEnabled: boolean;
    }): void;
    protected resetPathAnimation(data: CartesianAnimationData<TNode, TDatum, TLabel, TContext>): void;
    protected resetDatumAnimation(data: CartesianAnimationData<TNode, TDatum, TLabel, TContext>): void;
    protected resetLabelAnimation(data: CartesianAnimationData<TNode, TDatum, TLabel, TContext>): void;
    protected resetMarkerAnimation(data: CartesianAnimationData<TNode, TDatum, TLabel, TContext>): void;
    protected resetAllAnimation(data: CartesianAnimationData<TNode, TDatum, TLabel, TContext>): void;
    protected animateEmptyUpdateReady(data: CartesianAnimationData<TNode, TDatum, TLabel, TContext>): void;
    protected animateWaitingUpdateReady(data: CartesianAnimationData<TNode, TDatum, TLabel, TContext>): void;
    protected animateReadyHighlight(data: Selection<TNode, TDatum>): void;
    protected animateReadyHighlightMarkers(data: Selection<Marker, TDatum>): void;
    protected animateReadyResize(data: CartesianAnimationData<TNode, TDatum, TLabel, TContext>): void;
    protected animateClearingUpdateEmpty(data: CartesianAnimationData<TNode, TDatum, TLabel, TContext>): void;
    private getAnimationData;
    protected updateLabelSelection(opts: {
        labelData: TLabel[];
        labelSelection: Selection<Text, TLabel>;
    }): Selection<Text, TLabel>;
    protected abstract updateLabelNodes(opts: {
        labelSelection: Selection<Text, TLabel>;
    }): void;
    protected abstract isLabelEnabled(): boolean;
    protected getScaling(scale: Scale<any, any>): Scaling | undefined;
    protected calculateScaling(): {
        x?: Scaling | undefined;
        y?: Scaling | undefined;
    };
}
export {};
