import type { AgMarkerShape } from 'ag-charts-types';
import type { Gradient } from '../../scene/gradient/gradient';
import type { FillType } from '../../scene/util/fill';
export interface LegendMarker {
    shape?: AgMarkerShape;
    fill?: FillType;
    fillOpacity: number;
    stroke?: string | Gradient;
    strokeOpacity: number;
    strokeWidth: number;
    lineDash: number[];
    lineDashOffset: number;
    enabled?: boolean;
}
export interface LegendLine {
    stroke: string;
    strokeOpacity: number;
    strokeWidth: number;
    lineDash: number[];
}
export interface LegendSymbolOptions {
    marker: LegendMarker;
    line?: LegendLine;
}
export declare function legendSymbolSvg(symbol: LegendSymbolOptions, size: number, lineSize?: number): string | undefined;
