import { type EventListener } from 'ag-charts-core';
import type { LayoutContext as ILayoutContext } from '../../module/baseModule';
import type { Scale } from '../../scale/scale';
import { BBox } from '../../scene/bbox';
import type { TimeInterval } from '../../util/time';
import type { ChartAxisDirection } from '../chartAxisDirection';
export interface AxisLayout {
    id: string;
    rect: BBox;
    gridPadding: number;
    seriesAreaPadding: number;
    tickSize: number;
    label: {
        fractionDigits: number;
        spacing: number;
        format?: string;
    };
    direction: ChartAxisDirection;
    domain: any[];
    scale: Scale<any, any, number | TimeInterval>;
}
export type LayoutCompleteEvent = {
    readonly type: 'layout:complete';
    readonly chart: Readonly<{
        width: number;
        height: number;
    }>;
    readonly series: Readonly<{
        rect: BBox;
        paddedRect: BBox;
        visible: boolean;
    }>;
    readonly clipSeries: boolean;
    readonly axes?: Readonly<AxisLayout>[];
};
export interface LayoutState {
    axes?: AxisLayout[];
    clipSeries?: boolean;
    series: {
        rect: BBox;
        paddedRect: BBox;
        visible: boolean;
    };
}
interface EventMap {
    'layout:complete': LayoutCompleteEvent;
}
export declare enum LayoutElement {
    Caption = 0,
    Legend = 1,
    ToolbarLeft = 2,
    ToolbarBottom = 3,
    Navigator = 4,
    Overlay = 5
}
export declare class LayoutManager {
    private readonly events;
    private readonly elements;
    addListener<K extends keyof EventMap>(eventName: K, listener: EventListener<EventMap[K]>): () => void;
    registerElement(element: LayoutElement, listener: EventListener<LayoutContext>): () => boolean | undefined;
    createContext(width: number, height: number): LayoutContext;
    emitLayoutComplete(context: LayoutContext, options: LayoutState): void;
}
declare class LayoutContext implements ILayoutContext {
    readonly width: number;
    readonly height: number;
    readonly layoutBox: BBox;
    constructor(width: number, height: number);
}
export {};
