import type { DeepRequired } from 'ag-charts-core';
import type { AgChartInstance, AgTouchOptions } from 'ag-charts-types';
import { Group } from '../scene/group';
import type { CaptionLike } from './captionLike';
import type { ChartMode } from './chartMode';
import type { ISeries } from './series/seriesTypes';
export interface ChartService {
    readonly mode: ChartMode;
    readonly title: CaptionLike;
    readonly series: ISeries<any, any>[];
    readonly seriesRoot: Group;
    readonly publicApi?: AgChartInstance;
    readonly touch: DeepRequired<AgTouchOptions>;
    overrideFocusVisible(visible: boolean | undefined): void;
}
