import type { Scale } from '../../scale/scale';
import type { ChartAxis, ChartAxisLabelFlipFlag } from '../chartAxis';
import type { AxisInterval } from './axisInterval';
import type { TickInterval } from './axisTick';
import type { TickDatum } from './axisUtil';
import { NiceMode } from './axisUtil';
export interface TickData<D = any> {
    tickDomain: D[];
    rawTicks: D[];
    fractionDigits: number;
    ticks: TickDatum[];
    niceDomain?: D[];
}
export interface TickGenerationParams<D = any> {
    domain: D[];
    primaryTickCount: number | undefined;
    visibleRange: [number, number];
    niceMode: NiceMode;
    parallelFlipRotation: number;
    regularFlipRotation: number;
    labelX: number;
    sideFlag: ChartAxisLabelFlipFlag;
}
export interface TickGenerationResult<D = any> {
    tickData: TickData<D>;
    primaryTickCount?: number;
    combinedRotation: number;
    textBaseline: CanvasTextBaseline;
    textAlign: CanvasTextAlign;
}
export interface IAxis<S extends Scale<D, number, TickInterval<S>>, D> extends ChartAxis {
    interval: AxisInterval<S>;
    defaultTickMinSpacing: number;
    formatTick(value: any, index: number, fractionDigits?: number, formatter?: (datum: any) => string): string;
}
export declare class AxisTickGenerator<S extends Scale<D, number, TickInterval<S>>, D> {
    private readonly axis;
    constructor(axis: IAxis<S, D>);
    private estimateTickCount;
    private filterTicks;
    generateTicks({ domain, primaryTickCount, visibleRange, niceMode, parallelFlipRotation, regularFlipRotation, labelX, sideFlag, }: TickGenerationParams<D>): TickGenerationResult<D>;
    private getTickStrategies;
    private createTickData;
    private getTicks;
}
