import { inject, provide, computed } from "vue";
export const portalTargetInjectionKey = Symbol("nuxt-ui.portal-target");
export function usePortal(portal) {
  const portalTarget = inject(portalTargetInjectionKey, void 0);
  const to = computed(() => {
    if (typeof portal.value === "boolean" || portal.value === void 0) {
      return portalTarget?.value ?? "body";
    }
    return portal.value;
  });
  const disabled = computed(() => typeof portal.value === "boolean" ? !portal.value : false);
  provide(portalTargetInjectionKey, computed(() => to.value));
  return computed(() => ({
    to: to.value,
    disabled: disabled.value
  }));
}
