import * as AriaUtils from './aria';
export declare const _: {
    utf8_encode(s: string | null): string;
    capitalise(str: string): string;
    escapeString(toEscape?: string | null | undefined, skipEscapingHtmlChars?: boolean | undefined): string | null;
    camelCaseToHumanText(camelCase: string | undefined): string | null;
    camelCaseToHyphenated(camelCase: string): string;
    convertToSet<T>(list: T[]): Set<T>;
    sortRowNodesByOrder(rowNodes: import("../main").RowNode<any>[], rowNodeOrder: {
        [id: string]: number;
    }): boolean;
    iterateObject<T_1>(object: {
        [p: string]: T_1;
    } | T_1[] | null | undefined, callback: (key: string, value: T_1) => void): void;
    cloneObject<T_2 extends {}>(object: T_2): T_2;
    deepCloneDefinition<T_3>(object: T_3, keysToSkip?: string[] | undefined): T_3 | undefined;
    getAllValuesInObject<T_4 extends Object, K extends keyof T_4, O extends T_4[K]>(obj: T_4): O[];
    mergeDeep(dest: any, source: any, copyUndefined?: boolean, makeCopyOfSimpleObjects?: boolean): void;
    getValueUsingField(data: any, field: string, fieldContainsDots: boolean): any;
    removeAllReferences<T_5>(obj: any, preserveKeys: (keyof T_5)[] | undefined, preDestroyLink: string): void;
    isNonNullObject(value: any): boolean;
    SKIP_JS_BUILTINS: Set<string>;
    padStartWidthZeros(value: number, totalStringSize: number): string;
    createArrayOfNumbers(first: number, last: number): number[];
    cleanNumber(value: any): number | null;
    decToHex(number: number, bytes: number): string;
    formatNumberTwoDecimalPlacesAndCommas(value: number, thousandSeparator: string, decimalSeparator: string): string;
    formatNumberCommas(value: number, thousandSeparator: string, decimalSeparator: string): string;
    sum(values: number[] | null): number | null;
    areEventsNear(e1: MouseEvent | Touch, e2: MouseEvent | Touch, pixelCount: number): boolean;
    convertToMap<K_1, V>(arr: [K_1, V][]): Map<K_1, V>;
    mapById<V_1>(arr: V_1[], callback: (obj: V_1) => string): Map<string, V_1>;
    keys<T_6>(map: Map<T_6, any>): T_6[];
    isEventFromPrintableCharacter(event: KeyboardEvent): boolean;
    isUserSuppressingKeyboardEvent(gos: import("../gridOptionsService").GridOptionsService, keyboardEvent: KeyboardEvent, rowNode: import("../main").IRowNode<any>, column: import("../main").Column<any>, editing: boolean): boolean;
    isUserSuppressingHeaderKeyboardEvent(gos: import("../gridOptionsService").GridOptionsService, keyboardEvent: KeyboardEvent, headerRowIndex: number, column: import("../main").Column<any> | import("../main").ColumnGroup): boolean;
    normaliseQwertyAzerty(keyboardEvent: KeyboardEvent): string;
    isDeleteKey(key: string, alwaysReturnFalseOnBackspace?: boolean): boolean;
    createIcon(iconName: string, gos: import("../gridOptionsService").GridOptionsService, column: import("../main").Column<any> | null): Element;
    createIconNoSpan(iconName: string, gos: import("../gridOptionsService").GridOptionsService, column?: import("../main").Column<any> | null | undefined, forceCreate?: boolean | undefined): Element | undefined;
    iconNameClassMap: {
        [key: string]: string;
    };
    makeNull<T_7 extends unknown>(value?: T_7 | undefined): T_7 | null;
    exists(value: string | null | undefined, allowEmptyString?: boolean | undefined): value is string;
    exists<T_8>(value: T_8): value is NonNullable<T_8>;
    missing<T_9>(value: T_9 | null | undefined): value is Exclude<undefined, T_9> | Exclude<null, T_9>;
    missingOrEmpty<T_10>(value?: string | T_10[] | null | undefined): boolean;
    toStringOrNull(value: any): string | null;
    attrToNumber(value?: string | number | null | undefined): number | null | undefined;
    attrToBoolean(value?: string | boolean | null | undefined): boolean | undefined;
    attrToString(value?: string | undefined): string | undefined;
    jsonEquals<T1, T2>(val1: T1, val2: T2): boolean;
    defaultComparator(valueA: any, valueB: any, accentedCompare?: boolean): number;
    values<T_11>(object: {
        [key: string]: T_11;
    } | Set<T_11> | Map<any, T_11>): T_11[];
    fuzzyCheckStrings(inputValues: string[], validValues: string[], allSuggestions: string[]): {
        [p: string]: string[];
    };
    fuzzySuggestions(inputValue: string, allSuggestions: string[], hideIrrelevant?: boolean | undefined, filterByPercentageOfBestMatch?: number | undefined): {
        values: string[];
        indices: number[];
    };
    doOnce(func: () => void, key: string): void;
    warnOnce(msg: string): void;
    errorOnce(msg: string): void;
    getFunctionName(funcConstructor: any): any;
    isFunction(val: any): boolean;
    executeInAWhile(funcs: Function[]): void;
    executeNextVMTurn(func: () => void): void;
    executeAfter(funcs: Function[], milliseconds?: number): void;
    debounce(func: (...args: any[]) => void, delay: number): (...args: any[]) => void;
    throttle(func: (...args: any[]) => void, wait: number): (...args: any[]) => void;
    waitUntil(condition: () => boolean, callback: () => void, timeout?: number, timeoutMessage?: string | undefined): void;
    compose<T_12>(...fns: Function[]): (arg: T_12) => T_12;
    noop: () => void;
    stopPropagationForAgGrid(event: Event): void;
    isStopPropagationForAgGrid(event: Event): boolean;
    getCtrlForEventTarget<T_13>(gos: import("../gridOptionsService").GridOptionsService, eventTarget: EventTarget | null, type: string): T_13 | null;
    isElementInEventPath(element: HTMLElement, event: Event): boolean;
    createEventPath(event: {
        target: EventTarget;
    }): EventTarget[];
    getEventPath(event: Event | {
        target: EventTarget;
    }): EventTarget[];
    addSafePassiveEventListener(frameworkOverrides: import("../main").IFrameworkOverrides, eElement: HTMLElement, event: string, listener: (event?: any) => void): void;
    isEventSupported: (eventName: any) => boolean;
    radioCssClass(element: HTMLElement, elementClass: string | null, otherElementClass?: string | null | undefined): void;
    isFocusableFormField(element: HTMLElement): boolean;
    setDisplayed(element: Element, displayed: boolean, options?: {
        skipAriaHidden?: boolean | undefined;
    }): void;
    setVisible(element: HTMLElement, visible: boolean, options?: {
        skipAriaHidden?: boolean | undefined;
    }): void;
    setDisabled(element: HTMLElement, disabled: boolean): void;
    isElementChildOfClass(element: HTMLElement | null, cls: string, maxNest?: number | HTMLElement | undefined): boolean;
    getElementSize(el: HTMLElement): {
        height: number;
        width: number;
        borderTopWidth: number;
        borderRightWidth: number;
        borderBottomWidth: number;
        borderLeftWidth: number;
        paddingTop: number;
        paddingRight: number;
        paddingBottom: number;
        paddingLeft: number;
        marginTop: number;
        marginRight: number;
        marginBottom: number;
        marginLeft: number;
        boxSizing: string;
    };
    getInnerHeight(el: HTMLElement): number;
    getInnerWidth(el: HTMLElement): number;
    getAbsoluteHeight(el: HTMLElement): number;
    getAbsoluteWidth(el: HTMLElement): number;
    getElementRectWithOffset(el: HTMLElement): {
        top: number;
        left: number;
        right: number;
        bottom: number;
    };
    isRtlNegativeScroll(): boolean;
    getScrollLeft(element: HTMLElement, rtl: boolean): number;
    setScrollLeft(element: HTMLElement, value: number, rtl: boolean): void;
    clearElement(el: HTMLElement): void;
    removeFromParent(node: Element | null): void;
    isInDOM(element: HTMLElement): boolean;
    isVisible(element: HTMLElement): any;
    loadTemplate(template: string): HTMLElement;
    ensureDomOrder(eContainer: HTMLElement, eChild: HTMLElement, eChildBefore?: HTMLElement | null | undefined): void;
    setDomChildOrder(eContainer: HTMLElement, orderedChildren: (HTMLElement | null)[]): void;
    insertWithDomOrder(eContainer: HTMLElement, eToInsert: HTMLElement, eChildBefore: HTMLElement | null): void;
    addStylesToElement(eElement: any, styles: import("../main").RowStyle | import("../main").CellStyle | null | undefined): void;
    isHorizontalScrollShowing(element: HTMLElement): boolean;
    isVerticalScrollShowing(element: HTMLElement): boolean;
    setElementWidth(element: HTMLElement, width: string | number): void;
    setFixedWidth(element: HTMLElement, width: string | number): void;
    setElementHeight(element: HTMLElement, height: string | number): void;
    setFixedHeight(element: HTMLElement, height: string | number): void;
    formatSize(size: string | number): string;
    isNodeOrElement(o: any): boolean;
    copyNodeList(nodeList: NodeListOf<Node> | null): Node[];
    iterateNamedNodeMap(map: NamedNodeMap, callback: (key: string, value: string) => void): void;
    addOrRemoveAttribute(element: HTMLElement, name: string, value: any): void;
    nodeListForEach<T_14 extends Node>(nodeList: NodeListOf<T_14> | null, action: (value: T_14) => void): void;
    bindCellRendererToHtmlElement(cellRendererPromise: import("./promise").AgPromise<import("../main").ICellRendererComp<any>>, eTarget: HTMLElement): void;
    FOCUSABLE_SELECTOR: "[tabindex], input, select, button, textarea, [href]";
    FOCUSABLE_EXCLUDE: "[disabled], .ag-disabled:not(.ag-button), .ag-disabled *";
    serialiseDate(date: Date | null, includeTime?: boolean, separator?: string): string | null;
    dateToFormattedString(date: Date, format?: string): string;
    parseDateTimeFromString(value?: string | null | undefined): Date | null;
    isBrowserSafari(): boolean;
    getSafariVersion(): number;
    isBrowserChrome(): boolean;
    isBrowserFirefox(): boolean;
    isMacOsUserAgent(): boolean;
    isIOSUserAgent(): boolean;
    browserSupportsPreventScroll(): boolean;
    getTabIndex(el: HTMLElement | null): string | null;
    getMaxDivHeight(): number;
    getBodyWidth(): number;
    getBodyHeight(): number;
    getScrollbarWidth(): number | null;
    isInvisibleScrollbar(): boolean;
    existsAndNotEmpty<T_15>(value?: T_15[] | undefined): boolean;
    last<T_16>(arr: T_16[]): T_16;
    last<T_17 extends Node>(arr: NodeListOf<T_17>): T_17;
    areEqual<T_18>(a?: T_18[] | null | undefined, b?: T_18[] | null | undefined, comparator?: ((a: T_18, b: T_18) => boolean) | undefined): boolean;
    shallowCompare(arr1: any[], arr2: any[]): boolean;
    sortNumerically(array: number[]): number[];
    removeRepeatsFromArray<T_19>(array: T_19[], object: T_19): void;
    removeFromUnorderedArray<T_20>(array: T_20[], object: T_20): void;
    removeFromArray<T_21>(array: T_21[], object: T_21): void;
    removeAllFromUnorderedArray<T_22>(array: T_22[], toRemove: T_22[]): void;
    removeAllFromArray<T_23>(array: T_23[], toRemove: T_23[]): void;
    insertIntoArray<T_24>(array: T_24[], object: T_24, toIndex: number): void;
    insertArrayIntoArray<T_25>(dest: T_25[], src: T_25[], toIndex: number): void;
    moveInArray<T_26>(array: T_26[], objectsToMove: T_26[], toIndex: number): void;
    includes<T_27>(array: T_27[], value: T_27): boolean;
    flatten<T_28>(arrayOfArrays: (T_28 | T_28[])[]): T_28[];
    pushAll<T_29>(target: T_29[], source: T_29[]): void;
    toStrings<T_30>(array: T_30[]): (string | null)[] | null;
    forEachReverse<T_31>(list: T_31[], action: (value: T_31, index: number) => void): void;
    setAriaRole(element: Element, role?: string | null | undefined): void;
    getAriaSortState(sortDirection: import("../main").SortDirection | "mixed"): AriaUtils.ColumnSortState;
    getAriaLevel(element: Element): number;
    getAriaPosInSet(element: Element): number;
    getAriaLabel(element: Element): string | null;
    setAriaLabel(element: Element, label?: string | null | undefined): void;
    setAriaLabelledBy(element: Element, labelledBy?: string | undefined): void;
    setAriaDescribedBy(element: Element, describedby?: string | undefined): void;
    setAriaLive(element: Element, live?: "polite" | "assertive" | "off" | null | undefined): void;
    setAriaAtomic(element: Element, atomic: boolean | null): void;
    setAriaRelevant(element: Element, relevant: "additions" | "additions text" | "all" | "removals" | "text" | null): void;
    setAriaLevel(element: Element, level: number): void;
    setAriaDisabled(element: Element, disabled: boolean): void;
    setAriaHidden(element: Element, hidden: boolean): void;
    setAriaActiveDescendant(element: Element, descendantId: string | null): void;
    setAriaExpanded(element: Element, expanded: boolean): void;
    removeAriaExpanded(element: Element): void;
    setAriaSetSize(element: Element, setsize: number): void;
    setAriaPosInSet(element: Element, position: number): void;
    setAriaMultiSelectable(element: Element, multiSelectable: boolean): void;
    setAriaRowCount(element: Element, rowCount: number): void;
    setAriaRowIndex(element: Element, rowIndex: number): void;
    setAriaColCount(element: Element, colCount: number): void;
    setAriaColIndex(element: Element, colIndex: number): void;
    setAriaColSpan(element: Element, colSpan: number): void;
    setAriaSort(element: Element, sort: AriaUtils.ColumnSortState): void;
    removeAriaSort(element: Element): void;
    setAriaSelected(element: Element, selected?: boolean | undefined): void;
    setAriaChecked(element: Element, checked?: boolean | undefined): void;
    setAriaControls(controllerElement: Element, controlledElement: Element): void;
    getAriaCheckboxStateName(translate: (key: string, defaultValue: string, variableValues?: string[] | undefined) => string, state?: boolean | undefined): string;
};
