import { BeanStub } from "./context/beanStub";
import { Column } from "./entities/column";
import { CellFocusedParams } from "./events";
import { CellPosition } from "./entities/cellPositionUtils";
import { RowNode } from "./entities/rowNode";
import { HeaderPosition } from "./headerRendering/common/headerPosition";
import { ColumnGroup } from "./entities/columnGroup";
import { NavigationService } from "./gridBodyComp/navigationService";
import { CtrlsService } from "./ctrlsService";
import { HeaderCellCtrl } from "./headerRendering/cells/column/headerCellCtrl";
import { TabToNextHeaderParams } from "./interfaces/iCallbackParams";
import { WithoutGridCommon } from "./interfaces/iCommon";
import { FilterManager } from "./filter/filterManager";
import { IAdvancedFilterService } from "./interfaces/iAdvancedFilterService";
export declare class FocusService extends BeanStub {
    private eGridDiv;
    private readonly columnModel;
    private readonly headerNavigationService;
    private headerPositionUtils;
    private readonly rowRenderer;
    private readonly rowPositionUtils;
    private readonly cellPositionUtils;
    navigationService: NavigationService;
    ctrlsService: CtrlsService;
    filterManager: FilterManager;
    private readonly rangeService?;
    readonly advancedFilterService?: IAdvancedFilterService;
    private gridCtrl;
    private focusedCellPosition;
    private restoredFocusedCellPosition;
    private focusedHeaderPosition;
    /** the column that had focus before it moved into the advanced filter */
    private advancedFilterFocusColumn;
    private static keyboardModeActive;
    private static instanceCount;
    private static addKeyboardModeEvents;
    private static removeKeyboardModeEvents;
    private static toggleKeyboardMode;
    private static unregisterGridCompController;
    private init;
    private registerKeyboardFocusEvents;
    onColumnEverythingChanged(): void;
    isKeyboardMode(): boolean;
    getFocusCellToUseAfterRefresh(): CellPosition | null;
    getFocusHeaderToUseAfterRefresh(): HeaderPosition | null;
    private isDomDataMissingInHierarchy;
    getFocusedCell(): CellPosition | null;
    shouldRestoreFocus(cell: CellPosition): boolean;
    private isCellRestoreFocused;
    setRestoreFocusedCell(cellPosition: CellPosition): void;
    private getFocusEventParams;
    clearFocusedCell(): void;
    setFocusedCell(params: CellFocusedParams): void;
    isCellFocused(cellPosition: CellPosition): boolean;
    isRowNodeFocused(rowNode: RowNode): boolean;
    isHeaderWrapperFocused(headerCtrl: HeaderCellCtrl): boolean;
    clearFocusedHeader(): void;
    getFocusedHeader(): HeaderPosition | null;
    setFocusedHeader(headerRowIndex: number, column: ColumnGroup | Column): void;
    focusHeaderPosition(params: {
        headerPosition: HeaderPosition | null;
        direction?: 'Before' | 'After' | null;
        fromTab?: boolean;
        allowUserOverride?: boolean;
        event?: KeyboardEvent;
        fromCell?: boolean;
        rowWithoutSpanValue?: number;
    }): boolean;
    focusHeaderPositionFromUserFunc(params: {
        userFunc: (params: WithoutGridCommon<TabToNextHeaderParams>) => boolean | HeaderPosition | null;
        headerPosition: HeaderPosition | null;
        direction?: 'Before' | 'After' | null;
        event?: KeyboardEvent;
    }): boolean;
    private getHeaderPositionFromUserFunc;
    private focusProvidedHeaderPosition;
    focusFirstHeader(): boolean;
    focusLastHeader(event?: KeyboardEvent): boolean;
    focusPreviousFromFirstCell(event?: KeyboardEvent): boolean;
    isAnyCellFocused(): boolean;
    isRowFocused(rowIndex: number, floating?: string | null): boolean;
    findFocusableElements(rootNode: HTMLElement, exclude?: string | null, onlyUnmanaged?: boolean): HTMLElement[];
    focusInto(rootNode: HTMLElement, up?: boolean, onlyUnmanaged?: boolean): boolean;
    findFocusableElementBeforeTabGuard(rootNode: HTMLElement, referenceElement?: HTMLElement): HTMLElement | null;
    findNextFocusableElement(rootNode?: HTMLElement, onlyManaged?: boolean | null, backwards?: boolean): HTMLElement | null;
    isTargetUnderManagedComponent(rootNode: HTMLElement, target?: HTMLElement): boolean;
    findTabbableParent(node: HTMLElement | null, limit?: number): HTMLElement | null;
    focusGridView(column?: Column, backwards?: boolean): boolean;
    focusNextGridCoreContainer(backwards: boolean, forceOut?: boolean): boolean;
    private focusAdvancedFilter;
    focusNextFromAdvancedFilter(backwards?: boolean, forceFirstColumn?: boolean): boolean;
    clearAdvancedFilterColumn(): void;
}
