"use strict";Object.defineProperty(exports, "__esModule", { value: true });exports.validateLicense = validateLicense;
var _ofetch = await jitiImport("ofetch");
var _pkgTypes = await jitiImport("pkg-types");function _getRequireWildcardCache(e) {if ("function" != typeof WeakMap) return null;var r = new WeakMap(),t = new WeakMap();return (_getRequireWildcardCache = function (e) {return e ? t : r;})(e);}function _interopRequireWildcard(e, r) {if (!r && e && e.__esModule) return e;if (null === e || "object" != typeof e && "function" != typeof e) return { default: e };var t = _getRequireWildcardCache(r);if (t && t.has(e)) return t.get(e);var n = { __proto__: null },a = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];}return n.default = e, t && t.set(e, n), n;}

async function validateLicense(opts) {
  if (!opts.key) {
    throw _createError(`Missing \`${opts.theme.env}\` license key.\nPurchase Nuxt UI Pro at \`${opts.theme.link}\` to build your app in production.`);
  }

  const gitInfo = opts.key !== 'oss' ? undefined /* privacy */ : (await _getLocalGitInfo(opts.dir)) || _getGitEnv();
  const projectName = gitInfo ? `${gitInfo.owner || ''}/${gitInfo.name || ''}` : await _getPkgName(opts.dir);

  try {
    await (0, _ofetch.ofetch)('https://api.nuxtlabs.com/ui-pro/verify', {
      headers: {
        'Authorization': `key ${opts.key}`,
        'x-nuxt-project': projectName
      },
      params: gitInfo ?
      {
        gitRepo: gitInfo.name,
        gitOrg: gitInfo.owner,
        gitUrl: gitInfo.url
      } :
      {}
    });
  } catch (error) {
    const statusType = Math.round(error.status / 100);
    if (statusType === 4) {
      throw _createError(`Invalid \`${opts.theme.env}\` license key.\nPurchase Nuxt UI Pro at \`${opts.theme.link}\` to build your app in production.`);
    }
    throw _createError('Cannot validate Nuxt UI Pro License: ' + error);
  }
}

function _createError(message) {
  const error = new Error(message);
  try {
    error.stack = '';
  } catch {/* runtime not supports */}
  return error;
}

// --- Utilities to get git info ---










async function _getLocalGitInfo(rootDir) {
  const remote = await _getLocalGitRemote(rootDir);
  if (!remote) {
    return;
  }

  // https://www.npmjs.com/package/git-url-parse#clipboard-example
  const gitUrlParse = await ((specifier) => new Promise((r) => r(`${specifier}`)).then((s) => jitiImport(s).then((m) => _interopRequireWildcard(m))))('git-url-parse').then((r) => r.default || r);
  const { name, owner, source } = gitUrlParse(remote);
  const url = `https://${source}/${owner}/${name}`;

  return {
    name: name || '',
    owner: owner || '',
    url
  };
}

async function _getLocalGitRemote(dir) {
  try {
    // https://www.npmjs.com/package/parse-git-config#options
    const parseGitConfig = await ((specifier) => new Promise((r) => r(`${specifier}`)).then((s) => jitiImport(s).then((m) => _interopRequireWildcard(m))))('parse-git-config').then(
      (m) => m.promise
    );
    const gitDir = await (0, _pkgTypes.findNearestFile)('.git/config', { startingFrom: dir });
    const parsed = await parseGitConfig({ path: gitDir });
    if (!parsed) {
      return;
    }
    const gitRemote = parsed['remote "origin"']?.url;
    return gitRemote;
  } catch {
    return;
  }
}

function _getGitEnv() {
  // https://github.com/unjs/std-env/issues/59
  const envInfo = {
    // Provider
    provider: process.env.VERCEL_GIT_PROVIDER // vercel
    || (process.env.GITHUB_SERVER_URL ? 'github' : undefined), // github
    // Owner
    owner: process.env.VERCEL_GIT_REPO_OWNER // vercel
    || process.env.GITHUB_REPOSITORY_OWNER // github
    || process.env.CI_PROJECT_PATH?.split('/').shift(), // gitlab
    // Name
    name: process.env.VERCEL_GIT_REPO_SLUG ||
    process.env.GITHUB_REPOSITORY?.split('/').pop() // github
    || process.env.CI_PROJECT_PATH?.split('/').splice(1).join('/'), // gitlab
    // Url
    url: process.env.REPOSITORY_URL // netlify
  };

  if (!envInfo.url && envInfo.provider && envInfo.owner && envInfo.name) {
    envInfo.url = `https://${envInfo.provider}.com/${envInfo.owner}/${envInfo.name}`;
  }

  if (!envInfo.name || !envInfo.owner || !envInfo.url) {
    return;
  }

  return {
    name: envInfo.name,
    owner: envInfo.owner,
    url: envInfo.url
  };
}

async function _getPkgName(dir) {
  if (process.env.npm_package_name) {
    return process.env.npm_package_name;
  }

  const projectPkg = await (0, _pkgTypes.readPackageJSON)(dir).catch(() => null);
  if (projectPkg?.name) {
    return projectPkg.name;
  }

  throw new Error('You must provide a `name` in your `package.json` to activate Nuxt UI Pro.');
} /* v9-beeabec0d2f01b90 */
