"use strict";Object.defineProperty(exports, "__esModule", { value: true });exports.default = void 0;var _consola = await jitiImport("consola");
var _utils = await jitiImport("consola/utils");
var _kit = await jitiImport("@nuxt/kit");
var _defu = await jitiImport("defu");

var _package = _interopRequireDefault(await jitiImport("../../package.json"));
var _license = await jitiImport("./license");function _interopRequireDefault(e) {return e && e.__esModule ? e : { default: e };}var _default = exports.default =








(0, _kit.defineNuxtModule)({
  meta: {
    name: 'ui-pro',
    configKey: 'uiPro',
    compatibility: {
      nuxt: '^3.10.0'
    }
  },
  defaults: {
    license: '',
    routerOptions: undefined,
    content: false,
    customScrollbars: true
  },
  setup(options, nuxt) {
    const resolver = (0, _kit.createResolver)("file:///var/lib/jenkins/workspace/build-logship-frontend/node_modules/@nuxt/ui-pro/modules/pro/index.ts");

    if (options.routerOptions || options.routerOptions === undefined) {
      nuxt.hook('pages:routerOptions', ({ files }) => {
        const customRouterOptions = files.find((file) => /\/app\/router\.options\.(ts|js)$/.exec(file.path));
        if (options.routerOptions === undefined && customRouterOptions) {
          console.warn(`You seem to have a custom router.options file \`${customRouterOptions.path}\`\nThe scrollBehavior will be overriden with ui-pro own router.options unless you set \`uiPro: { routerOptions: false }\` in your nuxt.config\nSet \`uiPro: { routerOptions: true }\` to disable this warning`);
        }
        files.push({
          path: resolver.resolve('runtime/app/router.options.ts'),
          optional: true
        });
      });
    }

    if (options.customScrollbars) {
      (0, _kit.addPlugin)({
        src: resolver.resolve('runtime/plugins/scrollbars.client.ts')
      });

      nuxt.options.css.push(resolver.resolve('runtime/assets/css/scrollbars.css'));
    }

    /**
     * Add Content components & utils only if Nuxt Content is present
     */
    if ((0, _kit.hasNuxtModule)('@nuxt/content') || options.content) {
      // Add auto-imported utils
      (0, _kit.addImportsDir)(resolver.resolve('runtime/utils'));

      (0, _kit.addComponentsDir)({
        path: resolver.resolve('runtime/components/global'),
        global: true,
        prefix: '',
        pathPrefix: false
      });

      (0, _kit.addComponentsDir)({
        path: resolver.resolve('runtime/components/content'),
        prefix: 'U',
        pathPrefix: false
      });

      (0, _kit.addComponentsDir)({
        path: resolver.resolve('runtime/components/docs'),
        prefix: 'U',
        pathPrefix: false
      });

      // @ts-ignore
      nuxt.options.content = (0, _defu.defu)(nuxt.options.content, {
        highlight: {
          theme: {
            light: 'material-theme-lighter',
            default: 'material-theme',
            dark: 'material-theme-palenight'
          },
          preload: ['json', 'js', 'ts', 'html', 'css', 'vue', 'diff', 'shell', 'markdown', 'yaml', 'bash', 'ini']
        },
        navigation: {
          fields: ['icon', 'to', 'target']
        }
      });

      // @ts-ignore
      nuxt.hook('tailwindcss:config', function (tailwindConfig) {
        tailwindConfig.content = tailwindConfig.content ?? { files: [] };
        (Array.isArray(tailwindConfig.content) ? tailwindConfig.content : tailwindConfig.content.files).push(resolver.resolve('./runtime/components/**/*.{vue,mjs,ts}'));
      });
    }

    /**
     * License
     */
    const theme = _package.default.theme || { env: 'NUXT_UI_PRO_LICENSE', link: 'https://ui.nuxt.com/pro' };
    const key = process.env[theme.env] || nuxt.options.uiPro?.license;
    if (nuxt.options.dev || nuxt.options._prepare || nuxt.options.test) {
      if (nuxt.options.dev && !key) {
        _consola.consola.box(
          _utils.colors.greenBright('Nuxt UI Pro') + '\n\n' +
          `Missing \`${theme.env}\` env variable, please add it to your \`.env\`.` + '\n\n' +
          _utils.colors.blueBright(`Purchase Nuxt UI Pro at ${theme.link} to build your app in production.`)
        );
      }
      return;
    }
    nuxt.hook('build:before', async () => {
      await (0, _license.validateLicense)({ key, theme, dir: nuxt.options.rootDir });
    });
  }
}); /* v9-8b623e30fd7ee825 */
