/*global ActiveXObject*/
/* utl.ts

	Purpose:
		
	Description:
		
	History:
		Fri Nov 27 12:29:52     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

*/
/** XML utilities.
 */
//zk.$package('zk.xml');

/** @class zk.xml.Utl
 * Utilities for parsing XML and others.
 * <p>Refer to {@link zUtl} for basic utilities.
 */
zk.xml.Utl = {
	/**
	 * Loads XML from the resource at the specified URL.
	 * If the callback method is specified, the URL is loaded asynchronously and
	 * the callback is called with the XML document after the document is loaded and parsed.
	 * @param String url
	 * @param Function callback
	 * @return DOMElement
	 */
	loadXML: function (url, callback) {
		var doc: DOMImplementation | XMLDocument = document.implementation;
		if (doc && doc.createDocument) {
			doc = doc.createDocument('', '', null); //FF, Safari, Opera
			if (callback)
				doc.onload = function () {callback(doc);};
		} else {
			doc = new ActiveXObject('Microsoft.XMLDOM');
			if (callback)
				doc['onreadystatechange'] = function () {
					if (doc['readyState'] == 4) callback(doc);
				};
		}
		if (!callback) doc['async'] = false;
		doc['load'].apply(doc, url);
		return doc;
	},
	/**
	 * Parses and returns the XML document from the specified text.
	 * @param String text
	 * @return DOMElement
	 */
	parseXML: function (text) {
		if (typeof DOMParser != 'undefined')
			return (new DOMParser()).parseFromString(text, 'text/xml');
			//FF, Safar, Opera
	
		var doc = new ActiveXObject('Microsoft.XMLDOM'); //IE
		doc.async = false;
		doc.loadXML(text);
		return doc;
	},
	/** Renames the type embedded in an URL
	 * For example,
<pre><code>
zk.xml.Utl.renType("/zkdemo/img/whatever-off.gif", "on");
	//return "/zkdemo/img/whatever-on.gif"
</code></pre>
	 * as shown above, it assumes the type is embedded after dash (-).
	 * @param String url the URL to modify
	 * @param String type the type to replace with
	 * @return String the new URL after replacing the type
	 */
	renType: function (url, type) {
		var j = url.lastIndexOf(';'),
			suffix;
		if (j >= 0) {
			suffix = url.substring(j);
			url = url.substring(0, j);
		} else
			suffix = '';

		j = url.lastIndexOf('.');
		if (j < 0) j = url.length; //no extension at all
		var	k = url.lastIndexOf('-'),
			m = url.lastIndexOf('/'),
			ext = j <= m ? '' : url.substring(j),
			pref = k <= m ? j <= m ? url : url.substring(0, j) : url.substring(0, k);
		if (type) type = '-' + type;
		else type = '';
		return pref + type + ext + suffix;
	},

	/** Returns the concatenation of the text nodes under the specified
	 * DOM element.
	 * @param DOMElement el the DOM element.
	 * @return String the text
	 */
	getElementValue: function (el) {
		var txt = '';
		for (let target: Element | null = el.firstElementChild; target; target = target.nextElementSibling)
			if (target['data']) txt += target['data'];
		return txt;
	}
};