/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.rhino;

import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.zkoss.xel.Function;
import org.zkoss.zk.scripting.util.GenericInterpreter;
import org.zkoss.zk.ui.Page;

public class RhinoInterpreter
extends GenericInterpreter {
    private Scriptable _global;

    Scriptable getGlobalScope() {
        return this._global;
    }

    @Override
    public Object getNativeInterpreter() {
        return this._global;
    }

    @Override
    protected void exec(String script) {
        Context.getCurrentContext().evaluateString(this._global, script, "zk", 1, null);
    }

    @Override
    protected boolean contains(String name) {
        return this._global.has(name, this._global);
    }

    @Override
    protected Object get(String name) {
        Object val = this._global.get(name, this._global);
        if (val == Scriptable.NOT_FOUND || val == Undefined.instance || val instanceof ScriptableObject || val == null) {
            return null;
        }
        Context.getCurrentContext();
        return Context.jsToJava((Object)val, (Class)ScriptRuntime.ObjectClass);
    }

    @Override
    protected void set(String name, Object value) {
        this._global.put(name, this._global, this.toJS(value));
    }

    private Object toJS(Object value) {
        return value == null || value instanceof Number || value instanceof String || value instanceof Boolean ? value : Context.toObject((Object)value, (Scriptable)this._global);
    }

    @Override
    protected void unset(String name) {
        this._global.delete(name);
    }

    @Override
    protected void beforeExec() {
        this.enterContext();
    }

    @Override
    protected void afterExec() {
        this.exitContext();
    }

    private Context enterContext() {
        return ContextFactory.getGlobal().enterContext();
    }

    private void exitContext() {
        Context.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Page owner, String zslang) {
        super.init(owner, zslang);
        Context ctx = this.enterContext();
        try {
            this._global = new GlobalScope(ctx);
        }
        finally {
            this.exitContext();
        }
    }

    @Override
    public void destroy() {
        this._global = null;
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getFunction(String name, Class[] argTypes) {
        this.enterContext();
        try {
            Object val = this._global.get(name, this._global);
            if (!(val instanceof org.mozilla.javascript.Function)) {
                Function function = null;
                return function;
            }
            RhinoFunction rhinoFunction = new RhinoFunction((org.mozilla.javascript.Function)val);
            return rhinoFunction;
        }
        finally {
            this.exitContext();
        }
    }

    private class RhinoFunction
    implements Function {
        private final org.mozilla.javascript.Function _func;

        private RhinoFunction(org.mozilla.javascript.Function func) {
            if (func == null) {
                throw new IllegalArgumentException("null");
            }
            this._func = func;
        }

        public Class[] getParameterTypes() {
            return new Class[0];
        }

        public Class getReturnType() {
            return Object.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object obj, Object[] args) throws Exception {
            Context ctx = RhinoInterpreter.this.enterContext();
            try {
                Scriptable scope = RhinoInterpreter.this.getGlobalScope();
                Object object = this._func.call(ctx, scope, scope, args);
                return object;
            }
            finally {
                RhinoInterpreter.this.exitContext();
            }
        }

        public Method toMethod() {
            return null;
        }
    }

    private class GlobalScope
    extends ImporterTopLevel {
        private GlobalScope(Context ctx) {
            super(ctx);
        }

        public Object get(String name, Scriptable start) {
            Object v;
            Object val = super.get(name, start);
            if ((val == Scriptable.NOT_FOUND || val == Undefined.instance) && (v = RhinoInterpreter.this.getFromNamespace(name)) != GenericInterpreter.UNDEFINED) {
                return RhinoInterpreter.this.toJS(v);
            }
            return val;
        }
    }
}

