/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.select.impl.ComponentIterator;
import org.zkoss.zk.ui.select.impl.ComponentMatchCtx;
import org.zkoss.zk.ui.select.impl.PseudoClassDef;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class BasicPseudoClassDefs {
    private static final Map<String, PseudoClassDef> _defs = new HashMap<String, PseudoClassDef>();

    public static PseudoClassDef getDefinition(String name) {
        return _defs.get(name);
    }

    private static boolean acceptNthPattern(int index, String pattern) {
        return "odd".equals(pattern) && index % 2 == 1 || "even".equals(pattern) && index % 2 == 0 || new NthChildPattern(pattern).accept(index);
    }

    static {
        _defs.put("root", new PseudoClassDef(){

            @Override
            public boolean accept(ComponentMatchCtx ctx, String ... parameters) {
                if (parameters.length > 0) {
                    return false;
                }
                return ctx.getComponent().getParent() == null;
            }
        });
        _defs.put("first-child", new PseudoClassDef(){

            @Override
            public boolean accept(ComponentMatchCtx ctx, String ... parameters) {
                if (parameters.length > 0) {
                    return false;
                }
                return ctx.getComponentChildIndex() == 0;
            }
        });
        _defs.put("last-child", new PseudoClassDef(){

            @Override
            public boolean accept(ComponentMatchCtx ctx, String ... parameters) {
                if (parameters.length > 0) {
                    return false;
                }
                return ctx.getComponentChildIndex() + 1 == ctx.getComponentSiblingSize();
            }
        });
        _defs.put("only-child", new PseudoClassDef(){

            @Override
            public boolean accept(ComponentMatchCtx ctx, String ... parameters) {
                if (parameters.length > 0) {
                    return false;
                }
                return ctx.getComponentSiblingSize() == 1;
            }
        });
        _defs.put("empty", new PseudoClassDef(){

            @Override
            public boolean accept(ComponentMatchCtx ctx, String ... parameters) {
                if (parameters.length > 0) {
                    return false;
                }
                return ctx.getComponent().getChildren().isEmpty();
            }
        });
        _defs.put("nth-child", new PseudoClassDef(){

            @Override
            public boolean accept(ComponentMatchCtx ctx, String ... parameters) {
                return parameters.length == 1 && BasicPseudoClassDefs.acceptNthPattern(ctx.getComponentChildIndex() + 1, parameters[0]);
            }
        });
        _defs.put("nth-last-child", new PseudoClassDef(){

            @Override
            public boolean accept(ComponentMatchCtx ctx, String ... parameters) {
                return parameters.length == 1 && BasicPseudoClassDefs.acceptNthPattern(ctx.getComponentSiblingSize() - ctx.getComponentChildIndex(), parameters[0]);
            }
        });
        _defs.put("host", new PseudoClassDef(){

            @Override
            public boolean accept(ComponentMatchCtx ctx, String ... parameters) {
                ComponentCtrl comp = (ComponentCtrl)((Object)ctx.getComponent());
                if (comp.getShadowRoots().isEmpty()) {
                    return false;
                }
                if (parameters.length == 0) {
                    return true;
                }
                ComponentIterator compIter = new ComponentIterator(ctx.getComponent(), parameters[0]);
                return compIter.hasNext() && ctx.getComponent() == compIter.next();
            }
        });
    }

    private static class NthChildPattern {
        private final int _preNum;
        private final int _postNum;
        private final boolean _valid;

        private NthChildPattern(String pattern) {
            int npos = pattern.indexOf(110);
            String preStr = npos < 0 ? "" : pattern.substring(0, npos);
            String postStr = npos < 0 ? pattern : pattern.substring(npos + 1);
            boolean bl = this._valid = Pattern.matches("(?:\\+|-)?\\d*", preStr) && Pattern.matches("(?:(?:\\+|-)?\\d+)?", postStr);
            this._preNum = this._valid ? this.value(preStr, npos < 0 ? 0 : 1) : -1;
            this._postNum = this._valid ? this.value(postStr, 0) : -1;
        }

        private boolean accept(int index) {
            if (!this._valid) {
                return false;
            }
            if (this._preNum == 0) {
                return index == this._postNum;
            }
            int diff = index - this._postNum;
            return diff % this._preNum == 0 && diff / this._preNum >= 0;
        }

        private int value(String str, int defValue) {
            if (Strings.isEmpty((String)str)) {
                return defValue;
            }
            char p = str.charAt(0);
            String s = p == '+' || p == '-' ? str.substring(1) : str;
            return (p == '-' ? -1 : 1) * (Strings.isEmpty((String)s) ? defValue : Integer.valueOf(s));
        }
    }
}

