/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.common;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.common.XFPropColor;
import org.zkoss.poi.util.LittleEndianOutput;

public class XFPropGradientStop {
    private double numPosition;
    XFPropColor color;

    public XFPropGradientStop(RecordInputStream in) {
        short unused = in.readShort();
        this.numPosition = in.readDouble();
        this.color = new XFPropColor(in);
    }

    public XFPropGradientStop(double numPosition, XFPropColor color) {
        this.numPosition = numPosition;
        this.color = color;
    }

    public int getDataSize() {
        return 10 + this.color.getDataSize();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(0);
        out.writeDouble(this.numPosition);
        this.color.serialize(out);
    }

    public void appendString(StringBuffer sb, String prefix) {
        sb.append(prefix).append("[XFPROPGRADIENTSTOP]").append("\n");
        sb.append(prefix).append("    .numPosition = ").append(this.numPosition).append("\n");
        sb.append(prefix).append("    .color       = \n");
        this.color.appendString(sb, prefix + "    ");
        sb.append(prefix).append("[/XFPROPGRADIENTSTOP]").append("\n");
    }
}

