/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarDir;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumVal;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrVal;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarDir;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.STGrouping;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartDirection;
import org.zkoss.poi.ss.usermodel.charts.ChartGrouping;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.ss.usermodel.charts.DataSources;

class XSSFChartUtil {
    private XSSFChartUtil() {
    }

    public static void buildAxDataSource(CTAxDataSource ctAxDataSource, ChartDataSource<?> dataSource) {
        if (dataSource.isNumeric()) {
            if (dataSource.isReference()) {
                XSSFChartUtil.buildNumRef(ctAxDataSource.addNewNumRef(), dataSource);
            } else {
                XSSFChartUtil.buildNumLit(ctAxDataSource.addNewNumLit(), dataSource);
            }
        } else if (dataSource.isReference()) {
            XSSFChartUtil.buildStrRef(ctAxDataSource.addNewStrRef(), dataSource);
        } else {
            XSSFChartUtil.buildStrLit(ctAxDataSource.addNewStrLit(), dataSource);
        }
    }

    public static ChartDataSource<? extends Number> buildDefaultNumDataSource(ChartDataSource<? extends Number> dataSource) {
        if (dataSource.isNumeric()) {
            return dataSource;
        }
        int len = dataSource.getPointCount();
        Integer[] ax = new Integer[len];
        for (int j = 0; j < len; ++j) {
            ax[j] = new Integer(j + 1);
        }
        return new DataSources.ArrayDataSource<Integer>(ax);
    }

    public static void buildNumDataSource(CTNumDataSource ctNumDataSource, ChartDataSource<? extends Number> dataSource) {
        if (dataSource.isReference()) {
            XSSFChartUtil.buildNumRef(ctNumDataSource.addNewNumRef(), dataSource);
        } else {
            XSSFChartUtil.buildNumLit(ctNumDataSource.addNewNumLit(), dataSource);
        }
    }

    private static void buildNumRef(CTNumRef ctNumRef, ChartDataSource<?> dataSource) {
        ctNumRef.setF(dataSource.getFormulaString());
        CTNumData cache = ctNumRef.addNewNumCache();
        XSSFChartUtil.fillNumCache(cache, dataSource);
    }

    private static void buildNumLit(CTNumData ctNumData, ChartDataSource<?> dataSource) {
        XSSFChartUtil.fillNumCache(ctNumData, dataSource);
    }

    private static void buildStrRef(CTStrRef ctStrRef, ChartDataSource<?> dataSource) {
        ctStrRef.setF(dataSource.getFormulaString());
        CTStrData cache = ctStrRef.addNewStrCache();
        XSSFChartUtil.fillStringCache(cache, dataSource);
    }

    private static void buildStrLit(CTStrData ctStrData, ChartDataSource<?> dataSource) {
        XSSFChartUtil.fillStringCache(ctStrData, dataSource);
    }

    private static void fillStringCache(CTStrData cache, ChartDataSource<?> dataSource) {
        int numOfPoints = dataSource.getPointCount();
        cache.addNewPtCount().setVal((long)numOfPoints);
        for (int i = 0; i < numOfPoints; ++i) {
            Object value = dataSource.getPointAt(i);
            if (value == null) continue;
            CTStrVal ctStrVal = cache.addNewPt();
            ctStrVal.setIdx((long)i);
            ctStrVal.setV(value.toString());
        }
    }

    private static void fillNumCache(CTNumData cache, ChartDataSource<?> dataSource) {
        int numOfPoints = dataSource.getPointCount();
        cache.addNewPtCount().setVal((long)numOfPoints);
        for (int i = 0; i < numOfPoints; ++i) {
            Number value = (Number)dataSource.getPointAt(i);
            if (value == null) continue;
            CTNumVal ctNumVal = cache.addNewPt();
            ctNumVal.setIdx((long)i);
            ctNumVal.setV(value.toString());
        }
    }

    public static void buildSerTx(CTSerTx ctSerTx, ChartTextSource textSource) {
        if (textSource.isReference()) {
            XSSFChartUtil.buildStrRef(ctSerTx.addNewStrRef(), textSource);
        } else {
            ctSerTx.setV(textSource.getTextString());
        }
    }

    private static void buildStrRef(CTStrRef ctStrRef, ChartTextSource textSource) {
        ctStrRef.setF(textSource.getFormulaString());
        CTStrData cache = ctStrRef.addNewStrCache();
        XSSFChartUtil.fillStringCache(cache, textSource);
    }

    private static void fillStringCache(CTStrData cache, ChartTextSource textSource) {
        cache.addNewPtCount().setVal(1L);
        CTStrVal ctStrVal = cache.addNewPt();
        ctStrVal.setIdx(0L);
        ctStrVal.setV(textSource.getTextString());
    }

    static STBarGrouping.Enum fromChartGroupingForBar(ChartGrouping grouping) {
        if (grouping == null) {
            return null;
        }
        switch (grouping) {
            case STANDARD: {
                return STBarGrouping.STANDARD;
            }
            case STACKED: {
                return STBarGrouping.STACKED;
            }
            case CLUSTERED: {
                return STBarGrouping.CLUSTERED;
            }
            case PERCENT_STACKED: {
                return STBarGrouping.PERCENT_STACKED;
            }
        }
        throw new IllegalArgumentException();
    }

    static ChartGrouping toChartGroupingForBar(CTBarGrouping ctBarGrouping) {
        if (ctBarGrouping == null) {
            return null;
        }
        switch (ctBarGrouping.getVal().intValue()) {
            case 3: {
                return ChartGrouping.STANDARD;
            }
            case 4: {
                return ChartGrouping.STACKED;
            }
            case 1: {
                return ChartGrouping.PERCENT_STACKED;
            }
            case 2: {
                return ChartGrouping.CLUSTERED;
            }
        }
        throw new IllegalArgumentException();
    }

    static STGrouping.Enum fromChartGrouping(ChartGrouping grouping) {
        if (grouping == null) {
            return null;
        }
        switch (grouping) {
            case STANDARD: {
                return STGrouping.STANDARD;
            }
            case STACKED: {
                return STGrouping.STACKED;
            }
            case PERCENT_STACKED: {
                return STGrouping.PERCENT_STACKED;
            }
        }
        throw new IllegalArgumentException();
    }

    static ChartGrouping toChartGrouping(CTGrouping ctGrouping) {
        if (ctGrouping == null) {
            return null;
        }
        switch (ctGrouping.getVal().intValue()) {
            case 1: {
                return ChartGrouping.PERCENT_STACKED;
            }
            case 2: {
                return ChartGrouping.STANDARD;
            }
            case 3: {
                return ChartGrouping.STACKED;
            }
        }
        throw new IllegalArgumentException();
    }

    static STBarDir.Enum fromBarDirection(ChartDirection dir) {
        if (dir == null) {
            return null;
        }
        switch (dir) {
            case HORIZONTAL: {
                return STBarDir.BAR;
            }
            case VERTICAL: {
                return STBarDir.COL;
            }
        }
        throw new IllegalArgumentException();
    }

    static ChartDirection toBarDirection(CTBarDir barDir) {
        if (barDir == null) {
            return null;
        }
        switch (barDir.getVal().intValue()) {
            case 1: {
                return ChartDirection.HORIZONTAL;
            }
            case 2: {
                return ChartDirection.VERTICAL;
            }
        }
        throw new IllegalArgumentException();
    }
}

