/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.BuiltInStyle;
import org.zkoss.poi.hssf.record.common.XLUnicodeString;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class StyleRecord
extends StandardRecord {
    public static final short sid = 659;
    private static final BitField styleIndexMask = BitFieldFactory.getInstance(4095);
    private static final BitField isBuiltinFlag = BitFieldFactory.getInstance(32768);
    private int field_1_xf_index;
    private BuiltInStyle builtInData;
    private XLUnicodeString user;

    public StyleRecord() {
        this.field_1_xf_index = isBuiltinFlag.set(this.field_1_xf_index);
    }

    public StyleRecord(int index, XLUnicodeString user) {
        this.setXFIndex(index);
        this.setBuiltin(false);
        this.user = user;
    }

    public StyleRecord(int index, BuiltInStyle data) {
        this.setXFIndex(index);
        this.setBuiltin(true);
        this.builtInData = data;
    }

    public StyleRecord(RecordInputStream in) {
        this.field_1_xf_index = in.readShort() & 0xFFFF;
        if (this.isBuiltin()) {
            this.builtInData = new BuiltInStyle(in);
        } else {
            this.user = new XLUnicodeString(in);
        }
    }

    public void setXFIndex(int xfIndex) {
        this.field_1_xf_index = styleIndexMask.setValue(this.field_1_xf_index, xfIndex);
    }

    public int getXFIndex() {
        return styleIndexMask.getValue(this.field_1_xf_index);
    }

    public void setName(String name) {
        this.user = new XLUnicodeString(name, true);
        this.field_1_xf_index = isBuiltinFlag.clear(this.field_1_xf_index);
        this.builtInData = null;
    }

    public void setBuiltinStyle(int builtinStyleId) {
        this.field_1_xf_index = isBuiltinFlag.set(this.field_1_xf_index);
        if (this.builtInData == null) {
            this.builtInData = new BuiltInStyle(builtinStyleId, -1);
        } else {
            this.builtInData.setBuiltInType(builtinStyleId);
        }
        this.user = null;
    }

    public void setOutlineStyleLevel(int level) {
        this.field_1_xf_index = isBuiltinFlag.set(this.field_1_xf_index);
        if (this.builtInData == null) {
            this.builtInData = new BuiltInStyle(0, -1);
        } else {
            this.builtInData.setOutlineLevel(level);
        }
        this.user = null;
    }

    public boolean isBuiltin() {
        return isBuiltinFlag.isSet(this.field_1_xf_index);
    }

    public void setBuiltin(boolean flag) {
        this.field_1_xf_index = isBuiltinFlag.setBoolean(this.field_1_xf_index, flag) & 0xFFFF;
    }

    public String getName() {
        return this.isBuiltin() ? "" : this.user.getString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[STYLE]\n");
        sb.append("    .xf_index_raw      = ").append(HexDump.shortToHex(this.field_1_xf_index)).append("\n");
        sb.append("        .type          = ").append(this.isBuiltin() ? "built-in" : "user-defined").append("\n");
        sb.append("        .xf_index      = ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        if (this.isBuiltin()) {
            sb.append("        .builtInData = \n");
            this.builtInData.appendString(sb, "            ");
        } else {
            sb.append("    .name          = \n");
            this.user.appendString(sb, "            ");
        }
        sb.append("[/STYLE]\n");
        return sb.toString();
    }

    @Override
    protected int getDataSize() {
        if (this.isBuiltin()) {
            return 4;
        }
        return 2 + this.user.getDataSize();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_xf_index);
        if (this.isBuiltin()) {
            this.builtInData.serialize(out);
        } else {
            this.user.serialize(out);
        }
    }

    @Override
    public short getSid() {
        return 659;
    }
}

