/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.model;

import java.io.ByteArrayOutputStream;
import org.zkoss.poi.ddf.EscherClientDataRecord;
import org.zkoss.poi.ddf.EscherContainerRecord;
import org.zkoss.poi.hslf.exceptions.HSLFException;
import org.zkoss.poi.hslf.model.Picture;
import org.zkoss.poi.hslf.model.Shape;
import org.zkoss.poi.hslf.record.AnimationInfo;
import org.zkoss.poi.hslf.record.AnimationInfoAtom;
import org.zkoss.poi.hslf.record.ExMCIMovie;
import org.zkoss.poi.hslf.record.ExObjList;
import org.zkoss.poi.hslf.record.ExVideoContainer;
import org.zkoss.poi.hslf.record.InteractiveInfo;
import org.zkoss.poi.hslf.record.InteractiveInfoAtom;
import org.zkoss.poi.hslf.record.OEShapeAtom;
import org.zkoss.poi.hslf.record.Record;
import org.zkoss.poi.hslf.record.RecordTypes;
import org.zkoss.poi.hslf.usermodel.SlideShow;

public final class MovieShape
extends Picture {
    public static final int DEFAULT_MOVIE_THUMBNAIL = -1;
    public static final int MOVIE_MPEG = 1;
    public static final int MOVIE_AVI = 2;

    public MovieShape(int movieIdx, int pictureIdx) {
        super(pictureIdx, null);
        this.setMovieIndex(movieIdx);
        this.setAutoPlay(true);
    }

    public MovieShape(int movieIdx, int idx, Shape parent) {
        super(idx, parent);
        this.setMovieIndex(movieIdx);
    }

    protected MovieShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    @Override
    protected EscherContainerRecord createSpContainer(int idx, boolean isChild) {
        this._escherContainer = super.createSpContainer(idx, isChild);
        this.setEscherProperty((short)127, 0x1000100);
        this.setEscherProperty((short)447, 65537);
        EscherClientDataRecord cldata = new EscherClientDataRecord();
        cldata.setOptions((short)15);
        this._escherContainer.addChildRecord(cldata);
        OEShapeAtom oe = new OEShapeAtom();
        InteractiveInfo info = new InteractiveInfo();
        InteractiveInfoAtom infoAtom = info.getInteractiveInfoAtom();
        infoAtom.setAction((byte)6);
        infoAtom.setHyperlinkType((byte)-1);
        AnimationInfo an = new AnimationInfo();
        AnimationInfoAtom anAtom = an.getAnimationInfoAtom();
        anAtom.setFlag(4, true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            oe.writeOut(out);
            an.writeOut(out);
            info.writeOut(out);
        }
        catch (Exception e) {
            throw new HSLFException(e);
        }
        cldata.setRemainingData(out.toByteArray());
        return this._escherContainer;
    }

    public void setMovieIndex(int idx) {
        OEShapeAtom oe = (OEShapeAtom)this.getClientDataRecord(RecordTypes.OEShapeAtom.typeID);
        oe.setOptions(idx);
        AnimationInfo an = (AnimationInfo)this.getClientDataRecord(RecordTypes.AnimationInfo.typeID);
        if (an != null) {
            AnimationInfoAtom ai = an.getAnimationInfoAtom();
            ai.setDimColor(0x7000000);
            ai.setFlag(4, true);
            ai.setFlag(256, true);
            ai.setFlag(1024, true);
            ai.setOrderID(idx + 1);
        }
    }

    public void setAutoPlay(boolean flag) {
        AnimationInfo an = (AnimationInfo)this.getClientDataRecord(RecordTypes.AnimationInfo.typeID);
        if (an != null) {
            an.getAnimationInfoAtom().setFlag(4, flag);
            this.updateClientData();
        }
    }

    public boolean isAutoPlay() {
        AnimationInfo an = (AnimationInfo)this.getClientDataRecord(RecordTypes.AnimationInfo.typeID);
        if (an != null) {
            return an.getAnimationInfoAtom().getFlag(4);
        }
        return false;
    }

    public String getPath() {
        OEShapeAtom oe = (OEShapeAtom)this.getClientDataRecord(RecordTypes.OEShapeAtom.typeID);
        int idx = oe.getOptions();
        SlideShow ppt = this.getSheet().getSlideShow();
        ExObjList lst = (ExObjList)ppt.getDocumentRecord().findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst == null) {
            return null;
        }
        Record[] r = lst.getChildRecords();
        for (int i = 0; i < r.length; ++i) {
            ExMCIMovie mci;
            ExVideoContainer exVideo;
            int objectId;
            if (!(r[i] instanceof ExMCIMovie) || (objectId = (exVideo = (mci = (ExMCIMovie)r[i]).getExVideo()).getExMediaAtom().getObjectId()) != idx) continue;
            return exVideo.getPathAtom().getText();
        }
        return null;
    }
}

