/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.model.CellRegion;
import io.keikai.ui.impl.undo.AbstractUndoableAction;
import io.keikai.ui.impl.undo.ReserveUtil;

public abstract class Abstract2DCellDataStyleAction
extends AbstractUndoableAction {
    private static final long serialVersionUID = -187507901641574749L;
    public static final int RESERVE_CONTENT = 1;
    public static final int RESERVE_STYLE = 2;
    public static final int RESERVE_MERGE = 4;
    public static final int RESERVE_ALL = 7;
    private final int _reserveType;
    private ReserveUtil.ReservedResult _destOldReserve = null;
    private ReserveUtil.ReservedResult _srcOldReserve = null;
    protected final Sheet _destSheet;
    protected final int _destRow;
    protected final int _destColumn;
    protected final int _destLastRow;
    protected final int _destLastColumn;
    private Range _pastedRange;
    protected final boolean _destWholeColumn;
    protected final boolean _destWholeRow;

    public Abstract2DCellDataStyleAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, boolean srcWholeColumn, boolean srcWholeRow, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn, boolean destWholeColumn, boolean destWholeRow, int reserveType) {
        super(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, srcWholeColumn, srcWholeRow);
        this._destSheet = destSheet;
        this._destRow = destRow;
        this._destColumn = destColumn;
        this._destLastRow = destLastRow;
        this._destLastColumn = destLastColumn;
        this._reserveType = reserveType;
        this._destWholeColumn = destWholeColumn;
        this._destWholeRow = destWholeRow;
    }

    @Deprecated
    public Abstract2DCellDataStyleAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, boolean srcWholeColumn, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn, boolean destWholeColumn, int reserveType) {
        this(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, srcWholeColumn, false, destSheet, destRow, destColumn, destLastRow, destLastColumn, destWholeColumn, false, reserveType);
    }

    public Abstract2DCellDataStyleAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn, int reserveType) {
        this(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, false, false, destSheet, destRow, destColumn, destLastRow, destLastColumn, false, false, reserveType);
    }

    @Override
    protected boolean isSheetProtected() {
        return this.isAnyCellProtected(this._sheet, new CellRegion(this._row, this._column, this._lastRow, this._lastColumn));
    }

    protected boolean isSrcSheetProtected() {
        return super.isSheetProtected();
    }

    protected boolean isDstSheetProtected() {
        try {
            return this._destSheet.isProtected();
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public Sheet getUndoSheet() {
        return this._destSheet;
    }

    @Override
    public Sheet getRedoSheet() {
        return this._destSheet;
    }

    protected int getReservedSrcRow() {
        return this._row;
    }

    protected int getReservedSrcColumn() {
        return this._column;
    }

    protected int getReservedSrcLastRow() {
        return this._lastRow;
    }

    protected int getReservedSrcLastColumn() {
        return this._lastColumn;
    }

    protected Sheet getReservedSrcSheet() {
        return this._sheet;
    }

    protected int getReservedDestRow() {
        return this._destRow;
    }

    protected int getReservedDestColumn() {
        return this._destColumn;
    }

    protected int getReservedDestLastRow() {
        return this._destLastRow;
    }

    protected int getReservedDestLastColumn() {
        return this._destLastColumn;
    }

    protected Sheet getReservedDestSheet() {
        return this._destSheet;
    }

    @Override
    public void doAction() {
        if (this.isSheetProtected()) {
            return;
        }
        int srcRow = this.getReservedSrcRow();
        int srcColumn = this.getReservedSrcColumn();
        int srcLastRow = this.getReservedSrcLastRow();
        int srcLastColumn = this.getReservedSrcLastColumn();
        Sheet srcSheet = this.getReservedSrcSheet();
        int destRow = this.getReservedDestRow();
        int destColumn = this.getReservedDestColumn();
        int destLastRow = this.getReservedDestLastRow();
        int destLastColumn = this.getReservedDestLastColumn();
        Sheet destSheet = this.getReservedDestSheet();
        this._srcOldReserve = ReserveUtil.reserve(srcSheet.getInternalSheet(), srcRow, srcColumn, srcLastRow, srcLastColumn, this._reserveType);
        this._destOldReserve = ReserveUtil.reserve(destSheet.getInternalSheet(), destRow, destColumn, destLastRow, destLastColumn, this._reserveType);
        this.applyAction();
    }

    protected void applyAction() {
        Range src = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
        Range dest = Ranges.range(this._destSheet, this._destRow, this._destColumn, this._destLastRow, this._destLastColumn);
        this._pastedRange = CellOperationUtil.cut(src, dest);
    }

    @Override
    public boolean isUndoable() {
        return this._destOldReserve != null && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public boolean isRedoable() {
        return this._destOldReserve == null && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public void undoAction() {
        if (this.isSheetProtected()) {
            return;
        }
        this._destOldReserve.restore();
        this._srcOldReserve.restore();
        this._srcOldReserve = null;
        this._destOldReserve = null;
    }

    @Override
    public AreaRef getRedoSelection() {
        return new AreaRef(this._destRow, this._destColumn, this._destLastRow, this._destLastColumn);
    }
}

