/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.hazelcast.service;

import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.idempiere.distributed.ITopic;
import org.idempiere.distributed.ITopicSubscriber;

public class TopicImpl<E>
implements ITopic<E> {
    private com.hazelcast.topic.ITopic<E> topic;
    private List<TopicSubscriberAdapter<E>> adapters;
    private Map<TopicSubscriberAdapter<E>, String> registrationMap;

    public TopicImpl(com.hazelcast.topic.ITopic<E> topic) {
        this.topic = topic;
        this.adapters = new ArrayList<TopicSubscriberAdapter<E>>();
        this.registrationMap = new HashMap<TopicSubscriberAdapter<E>, String>();
    }

    public String getName() {
        return this.topic.getName();
    }

    public void subscribe(ITopicSubscriber<E> subscriber) {
        TopicSubscriberAdapter<E> adapter = new TopicSubscriberAdapter<E>(subscriber);
        String registrationId = this.topic.addMessageListener(adapter).toString();
        this.adapters.add(adapter);
        this.registrationMap.put(adapter, registrationId);
    }

    public void unsubscribe(ITopicSubscriber<E> subscriber) {
        TopicSubscriberAdapter<E> found = null;
        for (TopicSubscriberAdapter<E> adapter : this.adapters) {
            if (adapter.subscriber != subscriber) continue;
            found = adapter;
            String registrationId = this.registrationMap.get(adapter);
            if (!this.topic.removeMessageListener(UUID.fromString(registrationId))) break;
            this.registrationMap.remove(adapter);
            break;
        }
        if (found != null) {
            this.adapters.remove(found);
        }
    }

    public void publish(E message) {
        this.topic.publish(message);
    }

    class TopicSubscriberAdapter<T>
    implements MessageListener<T> {
        protected ITopicSubscriber<T> subscriber;

        protected TopicSubscriberAdapter(ITopicSubscriber<T> subscriber) {
            this.subscriber = subscriber;
        }

        public void onMessage(Message<T> message) {
            this.subscriber.onMessage(message.getMessageObject());
        }
    }
}

