/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.sequence;

import com.hazelcast.internal.util.ConcurrencyDetection;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import java.util.concurrent.atomic.AtomicLongArray;

public abstract class AbstractCallIdSequence
implements CallIdSequence {
    private static final int INDEX_HEAD = 7;
    private static final int INDEX_TAIL = 15;
    private static final int MAX_CONCURRENT_CALLS = Integer.getInteger("hazelcast.concurrent.invocations.max", 10);
    private static final int MOD = 8;
    private final AtomicLongArray longs = new AtomicLongArray(24);
    private final int maxConcurrentInvocations;
    private final ConcurrencyDetection concurrencyDetection;

    public AbstractCallIdSequence(int maxConcurrentInvocations, ConcurrencyDetection concurrencyDetection) {
        Preconditions.checkPositive("maxConcurrentInvocations", maxConcurrentInvocations);
        this.concurrencyDetection = concurrencyDetection;
        this.maxConcurrentInvocations = maxConcurrentInvocations;
    }

    @Override
    public long next() {
        if (!this.hasSpace()) {
            this.handleNoSpaceLeft();
        }
        return this.forceNext();
    }

    protected abstract void handleNoSpaceLeft();

    @Override
    public long getLastCallId() {
        return this.longs.get(7);
    }

    @Override
    public int getMaxConcurrentInvocations() {
        return this.maxConcurrentInvocations;
    }

    @Override
    public void complete() {
        long newTail = this.longs.incrementAndGet(15);
        assert (newTail <= this.longs.get(7));
    }

    @Override
    public long forceNext() {
        long l = this.longs.incrementAndGet(7);
        if (QuickMath.modPowerOfTwo(l, 8) == 0L && this.concurrentInvocations() > (long)MAX_CONCURRENT_CALLS) {
            this.concurrencyDetection.onDetected();
        }
        return l;
    }

    long getTail() {
        return this.longs.get(15);
    }

    protected boolean hasSpace() {
        return this.concurrentInvocations() < (long)this.maxConcurrentInvocations;
    }

    public long concurrentInvocations() {
        return this.longs.get(7) - this.longs.get(15);
    }
}

