/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.Option;
import com.hazelcast.internal.tpcengine.net.AsyncSocketOptions;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;

public class NioAsyncServerSocketOptions
implements AsyncSocketOptions {
    private static final SocketOption<Boolean> STD_SOCK_OPT_SO_REUSEPORT = (SocketOption)ReflectionUtil.findStaticFieldValue(StandardSocketOptions.class, "SO_REUSEPORT");
    private final ServerSocketChannel serverSocketChannel;

    NioAsyncServerSocketOptions(ServerSocketChannel serverSocketChannel) {
        this.serverSocketChannel = serverSocketChannel;
    }

    private static SocketOption toSocketOption(Option option) {
        if (SO_RCVBUF.equals(option)) {
            return StandardSocketOptions.SO_RCVBUF;
        }
        if (SO_REUSEADDR.equals(option)) {
            return StandardSocketOptions.SO_REUSEADDR;
        }
        if (SO_REUSEPORT.equals(option)) {
            return STD_SOCK_OPT_SO_REUSEPORT;
        }
        return null;
    }

    @Override
    public boolean isSupported(Option option) {
        Preconditions.checkNotNull(option, "option");
        SocketOption socketOption = NioAsyncServerSocketOptions.toSocketOption(option);
        return this.isSupported(socketOption);
    }

    private boolean isSupported(SocketOption socketOption) {
        return socketOption != null && this.serverSocketChannel.supportedOptions().contains(socketOption);
    }

    @Override
    public <T> boolean setIfSupported(Option<T> option, T value) {
        Preconditions.checkNotNull(option, "option");
        Preconditions.checkNotNull(value, "value");
        try {
            SocketOption socketOption = NioAsyncServerSocketOptions.toSocketOption(option);
            if (this.isSupported(socketOption)) {
                this.serverSocketChannel.setOption(socketOption, (Object)value);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to set " + option.name() + " with value [" + value + "]", e);
        }
    }

    @Override
    public <T> T getIfSupported(Option<T> option) {
        Preconditions.checkNotNull(option, "option");
        try {
            SocketOption socketOption = NioAsyncServerSocketOptions.toSocketOption(option);
            if (this.isSupported(socketOption)) {
                return this.serverSocketChannel.getOption(socketOption);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to get option " + option.name(), e);
        }
    }
}

